/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webcontentio.docx;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.ametys.core.util.IgnoreRootHandler;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.excalibur.xml.dom.DOMSerializer;
import org.apache.excalibur.xml.sax.SAXParser;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocxGenerator
extends ServiceableGenerator {
    private DOMSerializer _domSerializer;

    public void service(ServiceManager sManager) throws ServiceException {
        super.service(sManager);
        this._domSerializer = (DOMSerializer)sManager.lookup(DOMSerializer.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        block18: {
            Map context = (Map)this.objectModel.get("parent-context");
            Document document = (Document)context.get("document");
            Document relations = (Document)context.get("relations");
            ZipFile zipFile = (ZipFile)context.get("zipFile");
            this.contentHandler.startDocument();
            this.contentHandler.startElement("", "document", "document", new AttributesImpl());
            this._domSerializer.serialize(document, (ContentHandler)new IgnoreRootHandler(this.contentHandler), this.lexicalHandler);
            this._domSerializer.serialize(relations, (ContentHandler)new IgnoreRootHandler(this.contentHandler), this.lexicalHandler);
            ZipArchiveEntry zipEntry = zipFile.getEntry("word/styles.xml");
            SAXParser saxParser = null;
            try {
                saxParser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                try (InputStream is = zipFile.getInputStream(zipEntry);){
                    saxParser.parse(new InputSource(is), (ContentHandler)new IgnoreRootHandler(this.contentHandler));
                }
                zipEntry = zipFile.getEntry("word/numbering.xml");
                if (zipEntry == null) break block18;
                is = zipFile.getInputStream(zipEntry);
                try {
                    saxParser.parse(new InputSource(is), (ContentHandler)new IgnoreRootHandler(this.contentHandler));
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (ServiceException e) {
                throw new SAXException("Unable to get a SAX parser.", (Exception)((Object)e));
            }
            finally {
                this.manager.release((Object)saxParser);
            }
        }
        this.contentHandler.endElement("", "document", "document");
        this.contentHandler.endDocument();
    }
}

