/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.webcontentio.archive;

import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipOutputStream;

import javax.jcr.Node;

import org.ametys.plugins.contentio.archive.ContentsArchiverHelper;
import org.ametys.plugins.contentio.archive.DefaultPluginArchiver;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.web.repository.site.Site;

/**
 * Default implementation of a {@link SitePluginArchiver}. It uses the JCR system view for all data but contents.
 * For contents, the {@link ContentsArchiverHelper} is used.
 */
public class DefaultSitePluginArchiver extends DefaultPluginArchiver implements SitePluginArchiver
{
    @Override
    public void export(Site site, String pluginName, Node pluginNode, ZipOutputStream zos, String prefix) throws IOException
    {
        export(pluginName, pluginNode, zos, prefix);
    }
    
    @Override
    public ImportReport partialImport(Site site, String pluginName, Node allPluginsNode, Path zipPath, String zipEntryPath, Merger merger) throws IOException
    {
        return partialImport(pluginName, allPluginsNode, zipPath, zipEntryPath, merger);
    }
}
