/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspacessite;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.cocoon.environment.Request;

import org.ametys.plugins.site.token.GetToken;

/**
 * Handle token for webdav requests.
 */
public class WebdavToken implements GetToken
{
    /** Regexp for webdav uri */
    public static final Pattern WEBDAV_URI_PATTERN = Pattern.compile("(?:.*/)?_workspaces/dav/[^/]+/([^/]+)/(.+)");
    
    public String getToken(Request request)
    {
        String uri = request.getSitemapURI();
        
        Matcher matcher = WEBDAV_URI_PATTERN.matcher(uri);
        if (matcher.matches())
        {
            String token = matcher.group(1);
            return token;
        }
        
        return null;
    }

    public String getTokenContext(Request request)
    {
        String uri = request.getSitemapURI();
        
        Matcher matcher = WEBDAV_URI_PATTERN.matcher(uri);
        if (matcher.matches())
        {
            String context = matcher.group(2);
            return context;
        }
        return null;
    }
}
