/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityType;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.notification.ResourceNotifierHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class DocumentsActivityType
extends AbstractWorkspacesActivityType {
    public static final String PARENT_FOLDER_PATH = "parentPath";
    public static final String PARENT_FOLDER_ID = "parentFolderId";
    public static final String PARENT_FOLDER = "parentFolder";
    public static final String FILE_DATA_NAME = "file";
    public static final String FILES_DATA_NAME = "files";
    public static final String EVENT_CATEGORY_DOCUMENTS = "documents";
    protected AmetysObjectResolver _ametysObjectResolver;
    private DocumentWorkspaceModule _documentModule;
    private ResourceNotifierHelper _resourceNotifierHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._ametysObjectResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)serviceManager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._documentModule = (DocumentWorkspaceModule)moduleManagerEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
        this._resourceNotifierHelper = (ResourceNotifierHelper)serviceManager.lookup(ResourceNotifierHelper.ROLE);
    }

    public boolean supports(Event event) {
        return !event.getId().equals("resource.updated") || this._isResourceRecentlyModified(event);
    }

    private boolean _isResourceRecentlyModified(Event event) {
        String resourceId = event.getArguments().getOrDefault("object.id", null);
        return !this._resourceNotifierHelper.resourceRecentlyModified(resourceId);
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        activity.setValue("category", (Object)EVENT_CATEGORY_DOCUMENTS);
        String folderId = (String)parameters.get("object.parent");
        ResourceCollection parentFolder = null;
        if (folderId == null) {
            String resourceId = (String)parameters.get("object.id");
            Resource resource = (Resource)this._ametysObjectResolver.resolveById(resourceId);
            parentFolder = (ResourceCollection)resource.getParent();
            folderId = parentFolder.getId();
        } else {
            parentFolder = (ResourceCollection)this._ametysObjectResolver.resolveById(folderId);
        }
        activity.setValue(PARENT_FOLDER_ID, (Object)folderId);
        String parentFolderName = parentFolder.getName();
        if ("ametys-internal:resources".equals(parentFolderName)) {
            parentFolderName = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.explorer", "PLUGINS_EXPLORER_ROOT_NODE"));
        }
        activity.setValue(PARENT_FOLDER, (Object)parentFolderName);
        activity.setValue(PARENT_FOLDER_PATH, (Object)parentFolder.getExplorerPath());
    }

    @Override
    public Map<String, Object> additionnalDataToJSONForClient(Activity activity) {
        Map<String, Object> json = super.additionnalDataToJSONForClient(activity);
        String parentId = (String)activity.getValue(PARENT_FOLDER_ID);
        String projectName = (String)activity.getValue("projectName");
        Project project = this._projectManager.getProject(projectName);
        if (project != null) {
            json.put("parentFolderUrl", this._documentModule.getFolderUri(project, parentId));
        }
        return json;
    }

    @Override
    public boolean isMergeable(Activity activity1, Activity activity2) {
        if (!super.isMergeable(activity1, activity2)) {
            return false;
        }
        String parentFolder1 = (String)activity1.getValue(PARENT_FOLDER_ID);
        String parentFolder2 = (String)activity2.getValue(PARENT_FOLDER_ID);
        return parentFolder1 != null && parentFolder2 != null && parentFolder1.equals(parentFolder2);
    }

    @Override
    public Expression getFilterPatternExpression(String pattern) {
        StringExpression folderExpr = new StringExpression(PARENT_FOLDER, Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true));
        StringExpression filesExpr = new StringExpression("files/*/name", Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true));
        StringExpression fileExpr = new StringExpression("file/name", Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true));
        return new OrExpression(new Expression[]{folderExpr, filesExpr, fileExpr});
    }

    public Map<String, Object> mergeActivities(List<Activity> activities) {
        Map mergedActivities = super.mergeActivities(activities);
        ArrayList<Map> files = new ArrayList<Map>();
        ArrayList<String> knownFiles = new ArrayList<String>();
        for (Activity activity : activities) {
            Map json = activity.toJSONForClient();
            if (json.containsKey(FILE_DATA_NAME)) {
                Map file = (Map)json.get(FILE_DATA_NAME);
                if (knownFiles.contains(file.get("id"))) continue;
                files.add((Map)json.get(FILE_DATA_NAME));
                knownFiles.add((String)file.get("id"));
                continue;
            }
            if (!json.containsKey(FILES_DATA_NAME)) continue;
            files.addAll((List)json.get(FILES_DATA_NAME));
        }
        if (files.size() > 0) {
            mergedActivities.put(FILES_DATA_NAME, files);
        }
        mergedActivities.put("amount", files.size());
        return mergedActivities;
    }

    @Override
    public Project getProjectFromEvent(Event event) {
        Map args = event.getArguments();
        String parentId = (String)args.get("object.parent");
        if (parentId != null) {
            return this.getParentProject(this._resolver.resolveById(parentId));
        }
        String resourceId = (String)args.get("object.id");
        Resource resource = (Resource)this._resolver.resolveById(resourceId);
        return this.getParentProject(resource.getParent());
    }
}

