/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.forums;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.forums.ThreadCommentReportedActivityType;
import org.ametys.plugins.workspaces.activities.forums.ThreadsActivityNotifier;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReportThreadCommentActivityNotifier
extends ThreadsActivityNotifier {
    protected UserLanguagesManager _userLanguageManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._userLanguageManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    @Override
    public boolean supports(ActivityType activityType) {
        return activityType instanceof ThreadCommentReportedActivityType;
    }

    @Override
    public Map<String, List<String>> getUsersToNotifyByLanguage(Activity activity) {
        boolean returnAll = (Boolean)Config.getInstance().getValue("runtime.mail.massive.sending");
        Thread thread = (Thread)this.getTargetAmetysObject(activity);
        AmetysObject project = thread.getParent();
        Set users = this._rightManager.getAllowedUsers("Plugins_Workspaces_Handle_Reported_Comment_Thread", (Object)project).resolveAllowedUsers(returnAll);
        Set usersWithOwnThreadRights = this._rightManager.getAllowedUsers("Plugins_Workspaces_Handle_Reported_Comment_Own_Thread", (Object)project).resolveAllowedUsers(returnAll).stream().filter(user -> user.equals((Object)thread.getAuthor())).collect(Collectors.toSet());
        users.addAll(usersWithOwnThreadRights);
        String defaultLanguage = this._userLanguageManager.getDefaultLanguage();
        return users.stream().map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).map(user -> Pair.of((Object)user.getLanguage(), (Object)user.getEmail())).filter(p -> StringUtils.isNotEmpty((CharSequence)((CharSequence)p.getRight()))).collect(Collectors.groupingBy(p -> (String)StringUtils.defaultIfBlank((CharSequence)((String)p.getLeft()), (CharSequence)defaultLanguage), Collectors.mapping(Pair::getRight, Collectors.toList())));
    }
}

