/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.projects;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityNotifier;
import org.ametys.plugins.workspaces.activities.projects.MemberAddedActivityType;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.notification.preferences.NotificationPreferencesHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MemberAddedActivityNotifier
extends AbstractWorkspacesActivityNotifier {
    protected GroupManager _groupManager;
    protected ProjectMemberManager _projectMemberManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
    }

    public boolean supports(ActivityType activityType) {
        return activityType instanceof MemberAddedActivityType;
    }

    @Override
    public Map<String, List<String>> getUsersToNotifyByLanguage(Activity activity) {
        Stream<Object> previousUser = null;
        Project project = this._projectManager.getProject((String)activity.getValue("projectName"));
        JCRProjectMember.MemberType memberType = JCRProjectMember.MemberType.valueOf(((String)activity.getValue("memberType")).toUpperCase());
        if (JCRProjectMember.MemberType.USER.equals((Object)memberType)) {
            User newUser;
            UserIdentity userIdentity = UserIdentity.stringToUserIdentity((String)((String)activity.getValue("member")));
            if (userIdentity != null && (newUser = this._userManager.getUser(userIdentity)) != null) {
                previousUser = this._projectMemberManager.getProjectMembers(project, true).stream().map(ProjectMemberManager.ProjectMember::getUser).filter(u -> !u.equals((Object)newUser));
            }
        } else {
            Group group;
            GroupIdentity groupIdentity = GroupIdentity.stringToGroupIdentity((String)((String)activity.getValue("member")));
            if (groupIdentity != null && (group = this._groupManager.getGroup(groupIdentity)) != null) {
                previousUser = this._projectMemberManager.getProjectMembers(project, false).stream().filter(member -> JCRProjectMember.MemberType.USER.equals((Object)member.getType()) || group.equals((Object)member.getGroup())).flatMap(member -> {
                    if (JCRProjectMember.MemberType.USER.equals((Object)member.getType())) {
                        return Stream.of(member.getUser());
                    }
                    return member.getGroup().getUsers().stream().map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0));
                });
            }
        }
        if (previousUser != null) {
            String defaultLanguage = this._userLanguagesManager.getDefaultLanguage();
            return previousUser.filter(user -> this._notificationPreferenceHelper.askedToBeNotified(user.getIdentity(), (String)activity.getValue("projectName"), NotificationPreferencesHelper.Frequency.EACH)).map(user -> Pair.of((Object)user.getLanguage(), (Object)user.getEmail())).filter(p -> StringUtils.isNotEmpty((CharSequence)((CharSequence)p.getRight()))).collect(Collectors.groupingBy(p -> (String)StringUtils.defaultIfBlank((CharSequence)((String)p.getLeft()), (CharSequence)defaultLanguage), Collectors.mapping(Pair::getRight, Collectors.toList())));
        }
        return Map.of();
    }

    @Override
    public String getMailBodyURI(Activity activity) {
        return "cocoon://_plugins/workspaces/notification-mail-member";
    }

    @Override
    public AmetysObject getTargetAmetysObject(Activity activity) {
        return null;
    }
}

