/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.jcr;

import java.time.ZonedDateTime;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.CommentableAmetysObject;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.explorer.resources.jcr.JCRResourceFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.workspaces.documents.jcr.FileFactory;

public class File
extends JCRResource<FileFactory>
implements CommentableAmetysObject<Comment> {
    public File(Node node, String parentPath, FileFactory factory) {
        super(node, parentPath, (JCRResourceFactory)factory);
    }

    public String getDescription() {
        try {
            Node fileNode = this.getNode();
            return fileNode.hasProperty("ametys:description") ? fileNode.getProperty("ametys:description").getString() : null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get description for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public void setDescription(String description) {
        try {
            Node fileNode = this.getNode();
            fileNode.setProperty("ametys:description", description);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set description for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public boolean isAutomaticallyGeneratedDescription() {
        try {
            Node fileNode = this.getNode();
            if (fileNode.hasProperty("ametys:isAutoGeneratedDescription")) {
                return fileNode.getProperty("ametys:isAutoGeneratedDescription").getBoolean();
            }
            return false;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get automatic description status for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public void setIsAutoGeneratedDescription(boolean isAutoGeneratedDescription) {
        try {
            Node fileNode = this.getNode();
            fileNode.setProperty("ametys:isAutoGeneratedDescription", isAutoGeneratedDescription);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set automatic description status for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public Comment createComment() {
        return new Comment(this._getCommentsDataHolder());
    }

    public Comment createComment(String commentId, ZonedDateTime creationDate) {
        return new Comment(this._getCommentsDataHolder(), commentId, creationDate);
    }

    public Comment getComment(String commentId) throws AmetysRepositoryException {
        return Comment.getComment((ModifiableModelLessDataHolder)this._getCommentsDataHolder(), (String)commentId);
    }

    public List<Comment> getComments(boolean includeNotValidatedComments, boolean includeValidatedComments) throws AmetysRepositoryException {
        return Comment.getComments((ModifiableModelLessDataHolder)this._getCommentsDataHolder(), (boolean)includeNotValidatedComments, (boolean)includeValidatedComments);
    }

    private ModifiableModelLessDataHolder _getCommentsDataHolder() {
        try {
            Node baseNode = this.getBaseNode();
            if (!baseNode.hasNode("ametys:comments")) {
                baseNode.addNode("ametys:comments", "ametys:compositeMetadata");
            }
            Node commentsNode = baseNode.getNode("ametys:comments");
            baseNode.getSession().save();
            JCRRepositoryData repositoryData = new JCRRepositoryData(commentsNode);
            return new DefaultModifiableModelLessDataHolder(((FileFactory)this._getFactory()).getUnversionedDataTypeExtensionPoint(), (ModifiableRepositoryData)repositoryData);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }
}

