/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.observers;

import java.util.Map;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.documents.WorkspaceFileAIHelper;
import org.ametys.plugins.workspaces.documents.jcr.File;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class FileAISummaryObserver
extends AbstractLogEnabled
implements AsyncObserver,
Serviceable {
    protected AmetysObjectResolver _resolver;
    private WorkspacesHelper _workspaceHelper;
    private WorkspaceFileAIHelper _workspaceFileAIHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._workspaceFileAIHelper = (WorkspaceFileAIHelper)((Object)manager.lookup(WorkspaceFileAIHelper.ROLE));
    }

    public int getPriority() {
        return 0;
    }

    public boolean supports(Event event) {
        boolean isEnabled = this._workspaceFileAIHelper.isAutomaticGenerationEnabled();
        return isEnabled && (event.getId().equals("resource.created") || event.getId().equals("resource.updated"));
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Map args = event.getArguments();
        if (event.getId().equals("resource.created")) {
            Map resources = (Map)args.get("resources");
            for (Resource resource : resources.values()) {
                Resource addedResource = (Resource)this._resolver.resolveById(resource.getId());
                this._generateSummaryForResource(addedResource);
            }
        } else if (event.getId().equals("resource.updated")) {
            String resourceId = (String)args.get("object.id");
            Resource resource = (Resource)this._resolver.resolveById(resourceId);
            this._generateSummaryForResource(resource);
        }
    }

    private void _generateSummaryForResource(Resource resource) throws Exception {
        File file;
        WorkspacesHelper.FileType fileType = this._workspaceHelper.getFileType(resource);
        if ((fileType == WorkspacesHelper.FileType.TEXT || fileType == WorkspacesHelper.FileType.PDF) && resource instanceof File && ((file = (File)resource).isAutomaticallyGeneratedDescription() || StringUtils.isBlank((CharSequence)file.getDescription()))) {
            this._workspaceFileAIHelper.generateFileDescription(file);
        }
    }
}

