/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.initialization;

import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.core.observation.Event;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.userdirectory.page.VirtualUserDirectoryPageFactory;
import org.ametys.plugins.workspaces.initialization.DefaultStaticPageInitializer;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableSitemapElement;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.jackrabbit.value.StringValue;

public class UserDirectoryPageInitializer
extends DefaultStaticPageInitializer {
    protected ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
    }

    @Override
    public Optional<? extends Page> createPage(ModifiableSitemapElement parent) {
        Page page;
        Optional<? extends Page> result = super.createPage(parent);
        if (result.isPresent() && (page = result.get()) instanceof ModifiablePage) {
            ModifiablePage page2 = (ModifiablePage)page;
            try {
                if (page2 instanceof JCRAmetysObject) {
                    JCRAmetysObject jcrPage = (JCRAmetysObject)page2;
                    StringValue virtualUserDirectoryPageFactoryClassName = new StringValue(VirtualUserDirectoryPageFactory.class.getName());
                    jcrPage.getNode().setProperty("ametys-internal:virtual", new Value[]{virtualUserDirectoryPageFactoryClassName});
                }
                page2.setValue("user-directory-root-contenttype", (Object)"org.ametys.plugins.workspaces.Content.member");
                page2.setValue("user-directory-root-view-name", (Object)"main");
                page2.setValue("user-directory-root-classification-metadata", (Object)"lastname");
                page2.setValue("user-directory-root-depth", (Object)2);
                page2.saveChanges();
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("page", page2);
                this._observationManager.notify(new Event("page.changed", this._currentUserProvider.getUser(), eventParams));
                eventParams.put("user.content.view.updated", true);
                this._observationManager.notify(new Event("user.directory.root.updated", this._currentUserProvider.getUser(), eventParams));
                String contentTypeContext = "/content-types/" + page2.getSiteName() + "/org.ametys.plugins.workspaces.Content.member";
                this._profileAssignmentStorageEP.allowProfileToAnyConnectedUser("READER", (Object)contentTypeContext);
                eventParams = new HashMap();
                eventParams.put("acl-context", contentTypeContext);
                eventParams.put("acl-profiles", Set.of("READER"));
                this._observationManager.notify(new Event("acl.update", this._currentUserProvider.getUser(), eventParams));
            }
            catch (RepositoryException e) {
                this.getLogger().error("Failed to set user directory root property", (Throwable)e);
            }
        }
        return result;
    }
}

