/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.MembersWorkspaceModule;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.usermanagement.UserSignUpConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProjectMembersGenerator
extends ServiceableGenerator {
    protected ProjectManager _projectManager;
    protected ProjectMemberManager _projectMemberManager;
    protected UserHelper _userHelper;
    protected UserDirectoryHelper _userDirectoryHelper;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected GroupManager _groupManager;
    protected UserSignUpConfiguration _signupConfig;
    protected RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)serviceManager.lookup(ProjectManager.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)serviceManager.lookup(ProjectMemberManager.ROLE));
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._userDirectoryHelper = (UserDirectoryHelper)serviceManager.lookup(UserDirectoryHelper.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._groupManager = (GroupManager)serviceManager.lookup(GroupManager.ROLE);
        this._signupConfig = (UserSignUpConfiguration)serviceManager.lookup(UserSignUpConfiguration.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Project project;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Page page = (Page)request.getAttribute(WebConstants.REQUEST_ATTR_PAGE);
        String lang = page.getSitemapName();
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        ModelAwareDataHolder serviceParameters2018 = zoneItem.getServiceParameters();
        long maxNbMembers = (Long)serviceParameters2018.getValue("nbMembers", false, (Object)-1L);
        boolean expandGroup = (Boolean)serviceParameters2018.getValue("expandGroup", false, (Object)false);
        this.contentHandler.startDocument();
        List<Project> projects = this._projectManager.getProjectsForSite(page.getSite());
        Project project2 = project = projects.isEmpty() ? null : projects.get(0);
        if (project == null) {
            throw new IllegalArgumentException("There is no project for site " + page.getSiteName());
        }
        try {
            String siteName;
            Set<ProjectMemberManager.ProjectMember> members = this._projectMemberManager.getProjectMembers(project, expandGroup);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("nbMembers", String.valueOf(members.size()));
            String memberPageId = this._getMembersPageId(project);
            if (memberPageId != null) {
                attrs.addCDATAAttribute("memberPageId", memberPageId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(siteName = (String)Config.getInstance().getValue("workspaces.member.userdirectory.site.name")))) {
                attrs.addCDATAAttribute("userDirectorySiteName", siteName);
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"project", (Attributes)attrs);
            UserIdentity[] managers = project.getManagers();
            int count = 0;
            Iterator<ProjectMemberManager.ProjectMember> it = members.iterator();
            while (it.hasNext() && (maxNbMembers < 1L || (long)count < maxNbMembers)) {
                ProjectMemberManager.ProjectMember member = it.next();
                this._saxMember(member, managers, lang);
                ++count;
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"project");
        }
        catch (AmetysRepositoryException e) {
            throw new ProcessingException("Unable to get project members", (Throwable)e);
        }
        this.contentHandler.endDocument();
    }

    protected String _getMembersPageId(Project project) {
        Page memberPage;
        Set<Page> memberPages = this._projectManager.getModulePages(project, MembersWorkspaceModule.MEMBERS_MODULE_ID);
        if (!memberPages.isEmpty() && this._rightManager.currentUserHasReadAccess((Object)(memberPage = memberPages.iterator().next()))) {
            return memberPage.getId();
        }
        return null;
    }

    protected void _saxMember(ProjectMemberManager.ProjectMember member, UserIdentity[] managers, String lang) throws SAXException, AmetysRepositoryException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("manager", String.valueOf(member.isManager()));
        if (member.isManager()) {
            int position = ArrayUtils.indexOf((Object[])managers, (Object)member.getUser().getIdentity());
            attrs.addCDATAAttribute("managerPosition", String.valueOf(position + 1));
        }
        attrs.addCDATAAttribute("type", member.getType().name().toLowerCase());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"member", (Attributes)attrs);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)member.getTitle());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"sortabletitle", (String)member.getSortableTitle());
        String role = member.getRole();
        if (StringUtils.isNotBlank((CharSequence)role)) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"role", (String)role);
        }
        if (member.getType().equals((Object)JCRProjectMember.MemberType.USER)) {
            User user = member.getUser();
            this._saxUser(user, lang);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"member");
    }

    protected void _saxUser(User user, String lang) throws SAXException, AmetysRepositoryException, IOException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"user");
        this._userHelper.saxUser(user, this.contentHandler, "info");
        Content userContent = this._userDirectoryHelper.getUserContent(user.getIdentity(), lang);
        if (userContent != null) {
            AttributesImpl contentAttrs = new AttributesImpl();
            contentAttrs.addCDATAAttribute("id", userContent.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"content", (Attributes)contentAttrs);
            ContentType contentType = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.userdirectory.Content.user");
            View view = contentType.getView("abstract");
            userContent.dataToSAX(this.contentHandler, (ViewItemAccessor)view, DataContext.newInstance().withLocale(LocaleUtils.toLocale((String)lang)).withEmptyValues(false));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"content");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"user");
    }
}

