/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members.observers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractMemberObserver
extends AbstractLogEnabled
implements AsyncObserver,
Serviceable {
    protected ServiceManager _smanager;
    protected GroupManager _groupManager;
    protected UserDirectoryHelper _userDirectoryHelper;
    protected SiteManager _siteManager;
    protected ProjectManager _projectManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._userDirectoryHelper = (UserDirectoryHelper)smanager.lookup(UserDirectoryHelper.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
    }

    public boolean supports(Event event) {
        String eventId = event.getId();
        return eventId.equals("member.added") || eventId.equals("member.deleted");
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        if (this._groupManager == null) {
            this._groupManager = (GroupManager)this._smanager.lookup(GroupManager.ROLE);
        }
        Map args = event.getArguments();
        JCRProjectMember.MemberType type = (JCRProjectMember.MemberType)((Object)args.get("project.member.identity.type"));
        String identity = (String)args.get("project.member.identity");
        Set users = null;
        if (JCRProjectMember.MemberType.USER == type) {
            UserIdentity user = UserIdentity.stringToUserIdentity((String)identity);
            users = Collections.singleton(user);
        } else {
            Group group = this._groupManager.getGroup(GroupIdentity.stringToGroupIdentity((String)identity));
            users = group.getUsers();
        }
        List<Content> userContents = this.getUserContents(users);
        this._internalObserve(event, userContents);
    }

    protected abstract void _internalObserve(Event var1, List<Content> var2) throws Exception;

    protected List<Content> getUserContents(Set<UserIdentity> users) {
        String catalogSiteName = this._projectManager.getCatalogSiteName();
        ArrayList<Content> contents = new ArrayList<Content>();
        Site site = this._siteManager.getSite(catalogSiteName);
        if (site != null) {
            Set languages = site.getSitemaps().stream().map(SimpleAmetysObject::getName).collect(Collectors.toSet());
            for (UserIdentity user : users) {
                for (String lang : languages) {
                    Content userContent = this._userDirectoryHelper.getUserContent(user, lang);
                    if (userContent == null) continue;
                    contents.add(userContent);
                }
            }
        }
        return contents;
    }
}

