/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.enumerators;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class ProjectPopulationEnumerator
extends AbstractLogEnabled
implements Enumerator<String>,
Serviceable,
Contextualizable {
    private UserPopulationDAO _userPopulationDAO;
    private PopulationContextHelper _populationContextHelper;
    private Context _context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._userPopulationDAO = (UserPopulationDAO)serviceManager.lookup(UserPopulationDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)serviceManager.lookup(PopulationContextHelper.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public I18nizableText getEntry(String code) throws Exception {
        UserPopulation population = this._userPopulationDAO.getUserPopulation(code);
        return population != null ? population.getLabel() : null;
    }

    public Map<String, I18nizableText> getEntries() throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = WebHelper.getSiteName((Request)request);
        Set populationIds = this._populationContextHelper.getUserPopulationsOnContexts(List.of("/sites/" + siteName, "/sites-fo/" + siteName), false);
        List populations = populationIds.stream().map(pId -> this._userPopulationDAO.getUserPopulation(pId)).collect(Collectors.toList());
        return populations.stream().collect(Collectors.toMap(UserPopulation::getId, UserPopulation::getLabel));
    }
}

