/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification;

import jakarta.mail.MessagingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.ametys.core.group.GroupManager;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.WebConstants;
import org.ametys.web.population.PopulationContextHelper;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;

public abstract class AbstractMemberMailNotifierObserver
extends AbstractLogEnabled
implements AsyncObserver,
PluginAware,
Serviceable,
Contextualizable {
    protected Context _context;
    protected String _pluginName;
    protected AmetysObjectResolver _resolver;
    protected I18nUtils _i18nUtils;
    protected ProjectMemberManager _projectMemberManager;
    protected ProjectManager _projectManager;
    protected SiteManager _siteManager;
    protected PopulationContextHelper _populationContextHelper;
    protected SourceResolver _srcResolver;
    protected UserManager _userManager;
    protected GroupManager _groupManager;
    protected RenderingContextHandler _renderingContextHandler;
    protected UserLanguagesManager _userLanguagesManager;
    protected WorkspacesHelper _workspacesHelper;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(org.ametys.core.user.population.PopulationContextHelper.ROLE);
        this._srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
        this._workspacesHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Map args = event.getArguments();
        String projectId = (String)args.get("projectId");
        Project project = (Project)this._resolver.resolveById(projectId);
        Site site = project.getSite();
        String lang = this._workspacesHelper.getLang(project, this._userLanguagesManager.getDefaultLanguage());
        I18nizableText i18nSubject = this.getI18nSubject(event, project);
        Map<String, List<String>> recipientsByLanguage = this.getUserToNotifyByLanguage(event, project);
        for (String language : recipientsByLanguage.keySet()) {
            String userLanguage = (String)StringUtils.defaultIfBlank((CharSequence)language, (CharSequence)lang);
            String subject = this._i18nUtils.translate((I18nizable)i18nSubject, userLanguage);
            String mailBody = null;
            Source source = null;
            RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
            try {
                this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
                Request request = ContextHelper.getRequest((Context)this._context);
                request.setAttribute("forceAbsoluteUrl", (Object)true);
                request.setAttribute("lang", (Object)userLanguage);
                request.setAttribute(WebConstants.REQUEST_ATTR_SITE, (Object)site);
                request.setAttribute("site", (Object)site.getName());
                request.setAttribute("skin", (Object)site.getSkinId());
                source = this._srcResolver.resolveURI(this.getMailBodyURI(event, project), null, Map.of("event", event, "project", project));
                try (InputStream is = source.getInputStream();){
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    SourceUtil.copy((InputStream)is, (OutputStream)bos);
                    mailBody = bos.toString("UTF-8");
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Failed to create mail body", e);
                }
                catch (Throwable throwable) {
                    this._renderingContextHandler.setRenderingContext(currentContext);
                    if (source != null) {
                        this._srcResolver.release(source);
                    }
                    throw throwable;
                }
            }
            this._renderingContextHandler.setRenderingContext(currentContext);
            if (source != null) {
                this._srcResolver.release(source);
            }
            try {
                SendMailHelper.newMail().withSubject(subject).withHTMLBody(mailBody).withRecipients(recipientsByLanguage.get(language)).withAsync(true).withInlineCSS(false).sendMail();
            }
            catch (MessagingException | IOException e) {
                this.getLogger().warn("Could not send a notification e-mail to " + String.valueOf(recipientsByLanguage) + " following his removal from the project " + project.getTitle(), e);
            }
        }
    }

    protected abstract Map<String, List<String>> getUserToNotifyByLanguage(Event var1, Project var2);

    protected String getMailBodyURI(Event event, Project project) {
        return "cocoon://_plugins/workspaces/notification-mail-member";
    }

    protected abstract I18nizableText getI18nSubject(Event var1, Project var2);
}

