/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ResourceNotifierHelper
implements Serviceable,
Component,
Initializable {
    public static final String ROLE = ResourceNotifierHelper.class.getName();
    private static final long __HISTORY_EXPIRATION_TIME = 300000L;
    private static final long __TIME_DURATION_BEFORE_NEXT_CLEAN = 10000L;
    protected CurrentUserProvider _currentUserProvider;
    private LinkedList<Map<String, Object>> _sentHistory;
    private long _lastCleanTime;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void initialize() throws Exception {
        this._sentHistory = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourceRecentlyModified(String resourceId) {
        if (resourceId == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        LinkedList<Map<String, Object>> linkedList = this._sentHistory;
        synchronized (linkedList) {
            this._cleanupHistory();
            for (Map map : this._sentHistory) {
                if (!map.get("resourceId").equals(resourceId)) continue;
                return true;
            }
            HashMap<String, Object> history = new HashMap<String, Object>();
            history.put("time", now);
            history.put("resourceId", resourceId);
            this._sentHistory.addLast(history);
        }
        return false;
    }

    private void _cleanupHistory() {
        if (this._lastCleanTime != 0L && this._lastCleanTime + 10000L > System.currentTimeMillis()) {
            return;
        }
        long from = System.currentTimeMillis() - 300000L;
        Map<String, Object> oldHistory = this._sentHistory.peek();
        while (oldHistory != null && (Long)oldHistory.get("time") < from) {
            this._sentHistory.remove();
            oldHistory = this._sentHistory.peek();
        }
        this._lastCleanTime = System.currentTimeMillis();
    }
}

