/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryHelper;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractSearchModuleGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;
    protected ProjectManager _projectManager;
    protected CurrentUserProvider _currentUserProvider;
    protected ProjectMemberManager _projectMembers;
    protected CategoryProviderExtensionPoint _categoryProviderEP;
    protected CategoryHelper _categoryHelper;
    protected UserHelper _userHelper;
    protected SiteManager _siteManager;
    protected WorkspaceModuleExtensionPoint _workspaceModuleEP;
    protected RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._projectMembers = (ProjectMemberManager)((Object)smanager.lookup(ProjectMemberManager.ROLE));
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._categoryHelper = (CategoryHelper)smanager.lookup(CategoryHelper.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._workspaceModuleEP = (WorkspaceModuleExtensionPoint)((Object)this.manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._rightManager = (RightManager)this.manager.lookup(RightManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String siteName = WebHelper.getSiteName((Request)request);
        String lang = request.getParameter("lang");
        String textfield = request.getParameter("textfield");
        request.setAttribute("sitemapLanguage", (Object)lang);
        request.setAttribute("skin", (Object)this._siteManager.getSite(siteName).getSkinId());
        int offset = this.parameters.getParameterAsInteger("offset", 0);
        int limit = this.parameters.getParameterAsInteger("limit", 10);
        int minLimit = this.parameters.getParameterAsInteger("minLimit", 10);
        this.contentHandler.startDocument();
        this.saxHits(siteName, lang, textfield, request, offset, limit, minLimit);
        this.contentHandler.endDocument();
    }

    protected void saxHits(List<? extends AmetysObject> results, String lang, int offset, int limit, int minLimit, long totalCount) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("count", String.valueOf(results.size()));
        attrs.addCDATAAttribute("total", String.valueOf(totalCount));
        attrs.addCDATAAttribute("offset", String.valueOf(offset));
        attrs.addCDATAAttribute("limit", String.valueOf(limit));
        attrs.addCDATAAttribute("minLimit", String.valueOf(minLimit));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"hits", (Attributes)attrs);
        for (AmetysObject ametysObject : results) {
            try {
                this.saxHit(ametysObject, lang);
            }
            catch (Exception e) {
                this.getLogger().error("Unable to sax result for object of id '" + ametysObject.getId() + "'", (Throwable)e);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"hits");
    }

    protected Project getProject(AmetysObject ao) {
        AmetysObject parent;
        for (parent = ao.getParent(); parent != null && !(parent instanceof Project); parent = parent.getParent()) {
        }
        return parent != null ? (Project)parent : null;
    }

    protected void saxProject(Project project) throws SAXException {
        if (project != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("name", project.getName());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"project", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)project.getTitle());
            Category category = project.getCategories().stream().findFirst().map(c -> (Category)this._categoryProviderEP.getTag((String)c, null)).orElse(null);
            this.saxCategory(category);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"project");
        }
    }

    protected void saxCategory(Category category) throws SAXException {
        if (category != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("name", category.getName());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"category", (Attributes)attrs);
            category.getTitle().toSAX(this.contentHandler, "title");
            this.saxCategoryColor(category);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"category");
        }
    }

    protected void saxCategoryColor(Category category) throws SAXException {
        Map<String, String> colors = this._categoryHelper.getCategoryColor(category);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"color");
        colors.entrySet().stream().forEach(LambdaUtils.wrapConsumer(entry -> XMLUtils.createElement((ContentHandler)this.contentHandler, (String)((String)entry.getKey()), (String)((String)entry.getValue()))));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"color");
    }

    public List<Project> getProjects(Request request, boolean userOnly) {
        List projectNames = Arrays.asList(request.getParameter("project").split(",")).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        Set<String> filteredCategories = this.getCategories(request);
        if (projectNames.size() > 0) {
            return projectNames.stream().map(p -> this._projectManager.getProject((String)p)).filter(p -> !Collections.disjoint(p.getCategories(), filteredCategories)).collect(Collectors.toList());
        }
        if (userOnly) {
            UserIdentity user = this._currentUserProvider.getUser();
            return this._projectManager.getUserProjects(user, filteredCategories).keySet().stream().collect(Collectors.toList());
        }
        return this._projectManager.getProjects(filteredCategories);
    }

    protected List<Project> filterProjectsForModule(List<Project> projects, String moduleId) {
        Object module = this._workspaceModuleEP.getModule(moduleId);
        if (module == null || projects == null || projects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<Project> filteredProjects = projects.stream().filter(project -> this._projectManager.isModuleActivated((Project)((Object)project), module.getId())).filter(project -> this._rightManager.currentUserHasReadAccess((Object)module.getModuleRoot((Project)((Object)project), false))).collect(Collectors.toList());
        return filteredProjects;
    }

    protected Set<String> getCategories(Request request) {
        List categorieNames = Arrays.asList(request.getParameter("category").split(",")).stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (categorieNames.isEmpty()) {
            return this._categoryHelper.getLeafCategories().stream().map(Category::getName).collect(Collectors.toSet());
        }
        HashSet<String> filteredCategories = new HashSet<String>();
        for (String categoryName : categorieNames) {
            Category category = (Category)this._categoryProviderEP.getTag(categoryName, Collections.EMPTY_MAP);
            if (category == null) continue;
            filteredCategories.addAll(this._categoryHelper.getLeafCategories(category).stream().map(Category::getName).collect(Collectors.toSet()));
        }
        return filteredCategories;
    }

    protected abstract void saxHits(String var1, String var2, String var3, Request var4, int var5, int var6, int var7) throws SAXException, ProcessingException;

    protected abstract void saxHit(AmetysObject var1, String var2) throws Exception;

    protected void saxUser(UserIdentity userIdentity, String tagName) throws SAXException {
        if (userIdentity != null) {
            this._userHelper.saxUserIdentity(userIdentity, this.contentHandler, tagName);
        }
    }
}

