/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.util.HashSet;
import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.SortOrder;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.ContentLanguageQuery;
import org.ametys.cms.search.query.ContentTypeQuery;
import org.ametys.cms.search.query.FullTextQuery;
import org.ametys.cms.search.query.MatchNoneQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.plugins.workspaces.minisite.MiniSiteWorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.module.AbstractContentSolrSearchModuleGenerator;
import org.ametys.web.repository.content.WebContent;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class MiniSiteSearchModuleGenerator
extends AbstractContentSolrSearchModuleGenerator {
    @Override
    protected ContentSearcherFactory.SimpleContentSearcher getSearcher() {
        return this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.projectArticle"});
    }

    @Override
    protected String getSortFieldName() {
        return "lastModified";
    }

    @Override
    protected SortOrder getSortOrder() {
        return SortOrder.DESC;
    }

    @Override
    protected Query getQuery(String siteName, String lang, String textfield, Request request) {
        HashSet<Object> queries = new HashSet<Object>();
        if (StringUtils.isNotBlank((CharSequence)textfield)) {
            StringQuery titleQuery = new StringQuery("title", Query.Operator.SEARCH, textfield.trim(), lang);
            FullTextQuery fullTextQuery = new FullTextQuery(textfield.trim(), "full", lang, Query.Operator.SEARCH);
            queries.add(new OrQuery(new Query[]{titleQuery, fullTextQuery}));
        }
        List<Project> projects = this.getProjects(request, true);
        if ((projects = this.filterProjectsForModule(projects, MiniSiteWorkspaceModule.MINISITE_MODULE_ID)).isEmpty()) {
            return new MatchNoneQuery();
        }
        queries.add(this.getProjectArticleQuery(request, lang, projects));
        return new AndQuery(queries);
    }

    protected Query getProjectArticleQuery(Request request, String lang, List<Project> projects) {
        ContentTypeQuery projectArticleTypeQuery = new ContentTypeQuery(Query.Operator.EQ, new String[]{"org.ametys.plugins.workspaces.Content.projectArticle"});
        Query projectSiteQuery = this.getSiteQuery(projects);
        ContentLanguageQuery langQuery = new ContentLanguageQuery(lang);
        return new AndQuery(new Query[]{projectArticleTypeQuery, projectSiteQuery, langQuery});
    }

    @Override
    protected void saxAdditionalInformation(Content content) throws SAXException {
        super.saxAdditionalInformation(content);
        String siteName = ((WebContent)content).getSiteName();
        Project project = this._projectManager.getProject(siteName);
        if (project != null) {
            this.saxProject(project);
        }
    }
}

