/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.wall;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.Resource;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.Query;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.content.WebContentDAO;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneDAO;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.search.query.SiteQuery;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class WallContentModule
extends AbstractWorkspaceModule {
    public static final String WALLCONTENT_MODULE_ID = WallContentModule.class.getName();
    public static final String WALLCONTENT_SERVICE_ID = "org.ametys.web.service.SearchService";
    protected static final String[] SEARCH_SERVICE_CONTENT_TYPES = new String[]{"org.ametys.plugins.workspaces.Content.wallContent"};
    protected static final String[] SEARCH_SERVICE_RETURNABLES = new String[]{"org.ametys.web.frontoffice.search.metamodel.impl.ContentReturnable"};
    protected static final String[] SEARCH_SERVICE_SORTS = new String[]{"{\"name\":\"ContentReturnable$ContentSearchable$org.ametys.plugins.workspaces.Content.wallContent$pinned\",\"sort\":\"DESC\"}", "{\"name\":\"ContentReturnable$ContentSearchable$creationDate\",\"sort\":\"DESC\"}"};
    protected static final String[] SEARCH_SERVICE_CONTEXTS = new String[]{"{\"sites\":\"{\\\"context\\\":\\\"CURRENT_SITE\\\",\\\"sites\\\":[]}\",\"search-sitemap-context\":\"{\\\"context\\\":\\\"CURRENT_SITE\\\",\\\"page\\\":null}\",\"context-lang\":\"CURRENT\",\"tags\":[]}"};
    protected static final String SEARCH_SERVICE_XSLT = "pages/services/search/wall-content.xsl";
    private static final String __WORKSPACES_WALLCONTENT_NODE_NAME = "wallcontent";
    private static final String __WALLCONTENT_NUMBER_HEADER_ID = "wallcontent$wall_content_number";
    protected ZoneDAO _zoneDAO;
    protected WebContentDAO _contentDAO;
    protected ContentSearcherFactory _contentSearcherFactory;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._zoneDAO = (ZoneDAO)manager.lookup(ZoneDAO.ROLE);
        this._contentDAO = (WebContentDAO)manager.lookup(WebContentDAO.ROLE);
        this._contentSearcherFactory = (ContentSearcherFactory)manager.lookup(ContentSearcherFactory.ROLE);
    }

    @Override
    public String getId() {
        return WALLCONTENT_MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return __WORKSPACES_WALLCONTENT_NODE_NAME;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public Set<String> getAllowedEventTypes() {
        return ImmutableSet.of((Object)"wallcontent.added", (Object)"content.comment.validated");
    }

    @Override
    protected String getModulePageName() {
        return "index";
    }

    @Override
    public I18nizableText getModuleTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_WALLCONTENT_LABEL");
    }

    @Override
    public I18nizableText getModuleDescription() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_WALLCONTENT_DESCRIPTION");
    }

    @Override
    protected I18nizableText getModulePageTitle() {
        return null;
    }

    @Override
    protected void initializeModulePage(ModifiablePage modulePage) {
        ModifiableZone defaultZone = modulePage.hasZone("default") ? modulePage.getZone("default") : modulePage.createZone("default");
        boolean hasService = defaultZone.getZoneItems().stream().anyMatch(zi -> WALLCONTENT_SERVICE_ID.equals(zi.getServiceId()));
        if (!hasService) {
            ModifiableZoneItem defaultZoneItem = defaultZone.addZoneItem();
            defaultZoneItem.setType(ZoneItem.ZoneType.SERVICE);
            defaultZoneItem.setServiceId(WALLCONTENT_SERVICE_ID);
            ModifiableModelAwareDataHolder serviceDataHolder = defaultZoneItem.getServiceParameters();
            serviceDataHolder.setValue("header", null);
            serviceDataHolder.setValue("contentTypes", (Object)SEARCH_SERVICE_CONTENT_TYPES);
            serviceDataHolder.setValue("returnables", (Object)SEARCH_SERVICE_RETURNABLES);
            serviceDataHolder.setValue("initialSorts", (Object)SEARCH_SERVICE_SORTS);
            serviceDataHolder.setValue("contexts", (Object)SEARCH_SERVICE_CONTEXTS);
            serviceDataHolder.setValue("resultsPerPage", (Object)15);
            serviceDataHolder.setValue("rightCheckingMode", (Object)"exact");
            serviceDataHolder.setValue("resultPlace", (Object)"ABOVE_CRITERIA");
            serviceDataHolder.setValue("launchSearchAtStartup", (Object)true);
            serviceDataHolder.setValue("rss", (Object)false);
            serviceDataHolder.setValue("contentView", (Object)"main");
            serviceDataHolder.setValue("xslt", (Object)SEARCH_SERVICE_XSLT);
        }
    }

    @Override
    protected ModifiablePage _createModulePage(Project project, Sitemap sitemap, String name, I18nizableText pageTitle, String skinTemplate) {
        if (sitemap.hasChild(name)) {
            return (ModifiablePage)sitemap.getChild(name);
        }
        return super._createModulePage(project, sitemap, name, pageTitle, skinTemplate);
    }

    @Override
    protected void _deletePages(Project project) {
    }

    @Override
    protected void _internalDeactivateModule(Project project) {
        this._removeWallService(project);
    }

    @Override
    protected void _internalDeleteData(Project project) {
        this._removeWallService(project);
        this._deleteWallContents(project);
    }

    private void _deleteWallContents(Project project) {
        ContentTypeExpression cTypeExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.workspaces.Content.wallContent"});
        StringExpression siteExpr = new StringExpression("site", Expression.Operator.EQ, project.getSite().getName());
        AndExpression expr = new AndExpression(new Expression[]{cTypeExpr, siteExpr});
        String xPathQuery = ContentQueryHelper.getContentXPathQuery((Expression)expr);
        List contentIds = this._resolver.query(xPathQuery).stream().map(AmetysObject::getId).collect(Collectors.toList());
        this._contentDAO.deleteContents(contentIds, true);
    }

    private void _removeWallService(Project project) {
        List<Page> modulePages = this._getModulePages(project);
        for (Page page : modulePages) {
            if (!page.hasZone("default")) continue;
            this._projectManager.untagProjectPage((ModifiablePage)page, this.getModuleRoot(project, false));
            ModifiableZone defaultZone = ((ModifiablePage)page).getZone("default");
            Set zoneItemIds = defaultZone.getZoneItems().stream().filter(zi -> WALLCONTENT_SERVICE_ID.equals(zi.getServiceId())).map(AmetysObject::getId).collect(Collectors.toSet());
            for (String zoneItemId : zoneItemIds) {
                this._zoneDAO.removeZoneItem(zoneItemId);
            }
        }
    }

    @Override
    public Map<String, Object> _getInternalStatistics(Project project, boolean isActive) {
        if (isActive) {
            HashMap<String, Object> statistics = new HashMap<String, Object>();
            try {
                AmetysObjectIterable results = this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.wallContent"}).search((Query)new SiteQuery(new String[]{project.getName()}));
                statistics.put(__WALLCONTENT_NUMBER_HEADER_ID, results.getSize());
            }
            catch (Exception e) {
                this.getLogger().error("Error searching wall content in project " + project.getId(), (Throwable)e);
            }
            return statistics;
        }
        return Map.of(__WALLCONTENT_NUMBER_HEADER_ID, __SIZE_INACTIVE);
    }

    @Override
    public List<StatisticColumn> _getInternalStatisticModel() {
        return List.of(new StatisticColumn(__WALLCONTENT_NUMBER_HEADER_ID, new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_WALL_CONTENT_NUMBER")).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderElements").withType(StatisticsColumnType.LONG).withGroup("general$elements"));
    }

    @Override
    protected long _getModuleSize(Project project) {
        try {
            AmetysObjectIterable resultsIterable = this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.wallContent"}).search((Query)new SiteQuery(new String[]{project.getName()}));
            return resultsIterable.stream().map(content -> content.getValue("illustration/image")).filter(Objects::nonNull).filter(Binary.class::isInstance).map(Binary.class::cast).mapToLong(Resource::getLength).sum();
        }
        catch (Exception e) {
            this.getLogger().error("Error searching wall content images in project " + project.getId(), (Throwable)e);
            return -1L;
        }
    }

    @Override
    protected boolean _showModuleSize() {
        return true;
    }
}

