/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
try { logger; }
catch (e) { logger = Ametys.getLogger("org.ametys.core.migration.MigrationExtensionPoint.workspaces"); }

let count = 0;
function _removeZoneItem(zoneItem)
{
    zoneItem.remove();
    count++;
}

Repository.query("//element(*, ametys:zoneItem)[@ametys-internal:type='SERVICE' and @ametys-internal:service='org.ametys.plugins.workspaces.EditionFO']").forEach(function(zoneItem) {
  _removeZoneItem(zoneItem)
});

session.save();
logger.info(`${count} edition FO service(s) have been removed in default workspace`);

count = 0;
  
Repository.query("//element(*, ametys:zoneItem)[@ametys-internal:type='SERVICE' and @ametys-internal:service='org.ametys.plugins.workspaces.EditionFO']", true, Repository.liveSession).forEach(function(zoneItem) {
  _removeZoneItem(zoneItem)
});
Repository.liveSession.save();
logger.info(`${count} edition FO service(s) have been removed in live workspace`);
