<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:su="org.apache.commons.lang3.StringUtils"
                extension-element-prefixes="resolver su">
    
    <xsl:variable name="nl"><xsl:text>&#13;&#10;</xsl:text></xsl:variable>
    <xsl:variable name="nlstr"><xsl:text>\\n</xsl:text></xsl:variable>
    <xsl:variable name="workingDays">
        <xsl:call-template name="get-working-days" />
    </xsl:variable>
    <xsl:variable name="input-date-format">yyyy-MM-dd'T'HH:mm:ss.SSSX</xsl:variable>
        
    <xsl:template match="events">
        <xsl:text>BEGIN:VEVENT</xsl:text><xsl:value-of select="$nl"/>
        <xsl:text>UID:</xsl:text>
        <xsl:value-of select="id"/>
        <xsl:value-of select="$nl"/>
        <xsl:text>CREATED;VALUE=DATE-TIME:</xsl:text>
        <xsl:value-of select="creationDate"/>
        <xsl:value-of select="$nl"/>
        <xsl:text>LAST-MODIFIED;VALUE=DATE-TIME:</xsl:text>
        <xsl:value-of select="lastModified"/>
        <xsl:value-of select="$nl"/>
        <xsl:text>DTSTAMP;VALUE=DATE-TIME:</xsl:text>
        <xsl:value-of select="lastModified"/>
        <xsl:value-of select="$nl"/>
        
        <xsl:if test="startDate">
            <xsl:text>DTSTART;</xsl:text>
            <xsl:choose>
                <xsl:when test="fullDay = 'true'">
                     <xsl:text>VALUE=DATE:</xsl:text>
                     <i18n:date src-pattern="{$input-date-format}" pattern="yyyyMMdd" value="{startDate}"/>
                </xsl:when>
                <xsl:otherwise>
                     <xsl:text>VALUE=DATE-TIME:</xsl:text>
                     <xsl:value-of select="startDate"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="$nl"/>
        </xsl:if>
        
        <xsl:if test="endDate">
            <xsl:text>DTEND;</xsl:text>
            <xsl:choose>
                <xsl:when test="fullDay = 'true'">
                     <xsl:text>VALUE=DATE:</xsl:text>
                     <i18n:date src-pattern="{$input-date-format}" pattern="yyyyMMdd" value="{endDate}"/>
                </xsl:when>
                <xsl:otherwise>
                     <xsl:text>VALUE=DATE-TIME:</xsl:text>
                     <xsl:value-of select="endDate"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="$nl"/>
        </xsl:if>

        <!-- Recurrences -->
        <xsl:if test="not(recurrenceType = 'NEVER')">
            <xsl:choose>
                <xsl:when test="recurrenceType = 'ALL_DAY'">
                    <xsl:text>RRULE:FREQ=DAILY</xsl:text>
                </xsl:when>
                <xsl:when test="recurrenceType = 'WEEKLY'">
                    <xsl:text>RRULE:FREQ=WEEKLY</xsl:text>
                </xsl:when>
                <xsl:when test="recurrenceType = 'MONTHLY'">
                    <xsl:text>RRULE:FREQ=MONTHLY</xsl:text>
                </xsl:when>
                <xsl:when test="recurrenceType = 'BIWEEKLY'">
                    <xsl:text>RRULE:FREQ=WEEKLY;INTERVAL=2</xsl:text>
                </xsl:when>
                <xsl:when test="recurrenceType = 'ALL_WORKING_DAY'">
                    <!-- TODO faire un truc ici -->
                    <xsl:text>RRULE:FREQ=WEEKLY;BYDAY=</xsl:text>
                    <xsl:value-of select="$workingDays"/>
                </xsl:when>
            </xsl:choose> 
            <xsl:if test="untilDate">
                <xsl:text>;UNTIL=</xsl:text>
                <xsl:choose>
                    <xsl:when test="fullDay = 'true'">
                        <i18n:date src-pattern="{$input-date-format}" pattern="yyyyMMdd" value="{untilDate}"/>
                    </xsl:when>
                    <xsl:otherwise>
                         <xsl:value-of select="untilDate"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <xsl:value-of select="$nl"/>
        </xsl:if>
        <xsl:if test="excludedDates">
            <xsl:text>EXDATE;VALUE=DATE:</xsl:text><xsl:apply-templates select="excludedDates/excludedDates"/>
            <xsl:value-of select="$nl"/>
        </xsl:if>

        <xsl:text>SUMMARY:</xsl:text>
        <xsl:value-of select="title"/>
        <xsl:value-of select="$nl"/>
        <xsl:if test="description">
            <xsl:variable name="description" select="description"/>
            <xsl:variable name="description" select="su:replace($description, '\n', '\\n')"/>
            <xsl:variable name="description" select="su:replace($description, '\r', '\\r')"/>
            <xsl:variable name="description" select="su:replacePattern($description, '[\n\r]', $nlstr)"/>
            <xsl:text>DESCRIPTION:</xsl:text>
            <!-- replace each end of line with '\n' -->
            <xsl:value-of select="$description" />
            <xsl:value-of select="$nl"/>
        </xsl:if>
        
        <xsl:if test="location">
            <xsl:text>LOCATION:</xsl:text>
            <xsl:value-of select="location"/>
            <xsl:value-of select="$nl"/>
        </xsl:if>
        
        
        <xsl:if test="keywords">
            <xsl:text>CATEGORIES:</xsl:text><xsl:apply-templates select="keywords/keywords"/>
            <xsl:value-of select="$nl"/>
        </xsl:if>
        
        <xsl:text>END:VEVENT</xsl:text>
        <xsl:value-of select="$nl"/>
    </xsl:template>
    
    
    <xsl:template match="excludedDates">
        <i18n:date src-pattern="{$input-date-format}" pattern="yyyyMMdd" value="{.}"/>
        <xsl:if test="position()!=last()"><xsl:text>,</xsl:text></xsl:if>
    </xsl:template>
    
    <xsl:template match="keywords">
        <xsl:value-of select="." />
        <xsl:if test="position()!=last()"><xsl:text>,</xsl:text></xsl:if>
    </xsl:template>
    
    <xsl:template name="get-working-days">
        <xsl:for-each select="/ActionResult/workingDays/workingDays">
            <xsl:value-of select="." />
            <xsl:if test="position()!=last()"><xsl:text>,</xsl:text></xsl:if>
        </xsl:for-each>
    </xsl:template>
    
</xsl:stylesheet>
