/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
(function ($) {
    var scrollbar;
    var fakecontent;
    
    function _getOrCreateScrollBar()
    {
        if (!document.body)
        {
            throw Error("no body")
        }
        
        if (scrollbar == null)
        {
            scrollbar = $('<div data-fixed-scrollbar="true"><div></div></div>').appendTo($(document.body));
            scrollbar.hide().css({
                overflowX:'auto',
                position:'fixed',
                width:'100%',
                zIndex: 1000,
                bottom:0
            });
            scrollbar.scroll(scroll);
            
            fakecontent = scrollbar.find('div');
        }
        return scrollbar
    }
    var lastScroll;
    var all = [];
    var active = $([]);

    $(window).scroll(onscroll);
    $(window).resize(onscroll);    
    

    function top(e) {
        return e.offset().top;
    }

    function bottom(e) {
        return e.offset().top + e.height();
    }
    
    function find_active() {
        _getOrCreateScrollBar().show();
        var active = $([]);
        $(all).each(function() {
            if (top($(this)) < top(_getOrCreateScrollBar()) && bottom($(this)) > bottom(_getOrCreateScrollBar())) {
                fakecontent.width($(this).get(0).scrollWidth);
                fakecontent.height(1);
                active = $(this);
            }
        });
        fit(active);
        return active;
    }    
    
    function fit(active) {
        if (!active.length) return _getOrCreateScrollBar().hide();
        _getOrCreateScrollBar().css({left: active.offset().left, width:active.width()});
        fakecontent.width($(this).get(0).scrollWidth);
        fakecontent.height(1);
        lastScroll = undefined;
    }
    
    function onscroll(){
        var oldactive = active;
        active = find_active();
        if (oldactive.not(active).length) {
            oldactive.unbind('scroll', update);
        }
        if (active.not(oldactive).length) {
            active.scroll(update);
        }
        update();
    }
    
    function scroll() {
        if (!active.length) return;
        if (_getOrCreateScrollBar().scrollLeft() === lastScroll) return;
        lastScroll = _getOrCreateScrollBar().scrollLeft();
        active.scrollLeft(lastScroll);
    }
    
    function update() {
        if (!active.length) return;
        if (active.scrollLeft() === lastScroll) return;
        lastScroll = active.scrollLeft();
        _getOrCreateScrollBar().scrollLeft(lastScroll);
    }
    
    $.fn.fixedScrollbar = function() {
        return this.each(function() {
            if (all.indexOf(this) == -1)
            {
                all.push(this); 
                
                const resizeObserver = new ResizeObserver(() => onscroll());
                resizeObserver.observe(this);

                onscroll();
            }
        });
    }
}(jQuery));
