<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:uriutils="org.ametys.core.util.URIUtils"
                              exclude-result-prefixes="i18n project resolver ametys">
    
    <xsl:variable name="lang" select="ametys:lang()"/>
    <xsl:variable name="site-uri-prefix" select="ametys:siteUriPrefix()"/>
    <xsl:variable name="site" select="ametys:site()"/>
    <xsl:variable name="skin" select="ametys:skin()"/>
    
    <xsl:template match="/ActionResult">
        <html>
            <body>
                <ul class="ametys-notifications__list ametys-q-panel__list">
                    <xsl:apply-templates select="events/events" mode="as-event">
                        <xsl:sort select="date-iso" order="descending" />
                    </xsl:apply-templates>
                </ul>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="events" mode="as-event">
        <li class="ametys-notifications__list_item">
            <xsl:apply-templates select="." mode="event-header"/>
            
            <div class="ametys-q-panel__list_subtxt">
                <p>
                    <xsl:apply-templates select="." mode="event-body"/>
                </p>
                <xsl:apply-templates select="." mode="event-details"/>
            </div>
        </li>
    </xsl:template>
    
    <xsl:template match="events" mode="event-header">
        
        <div class="ametys-notifications__msg">
            <xsl:call-template name="as-event-unread"/>
            <xsl:call-template name="as-event-author-avatar"/>
            <div class="ametys-notifications__msg_descript">
                <xsl:call-template name="as-event-author"/>
                <div class="ametys-q-panel__list_tmd">
                    <xsl:call-template name="as-project-title"/>
                    <xsl:call-template name="as-event-date"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="as-event-unread">
        <xsl:if test="unread = 'true'">
            <span class="ametys-indicator ametys-indicator--bordered ametys-indicator--danger"></span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="as-event-author-avatar">
        <xsl:variable name="userImg">
            <xsl:choose>
                <xsl:when test="author/login">
                    <xsl:call-template name="author-img-url">
                        <xsl:with-param name="login" select="author/login"/>
                        <xsl:with-param name="population" select="author/populationId"/>
                        <xsl:with-param name="imgWidth">42</xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="anonymous-author-img-url"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <div class="ametys-notifications__msg_img ametys-notifications__msg_img-none">
            <img src="{$userImg}" alt="" />
        </div>
    </xsl:template>
    
    <xsl:template name="anonymous-author-img-url">
        <xsl:param name="imgWidth">42</xsl:param>         
        
        <xsl:value-of select="concat($site-uri-prefix, '/_plugins/core-ui/user/unknown/unknown/image_', $imgWidth, '?lang=', $lang)"/>
    </xsl:template>
    
    <xsl:template name="as-event-author">
        <h3>
            <xsl:choose>
                <xsl:when test="author/fullname"><xsl:value-of select="author/fullname"/></xsl:when>
                <xsl:otherwise><i18n:text i18n:key="PLUGINS_WORKSPACES_UNKNOWN_USER" i18n:catalogue="plugin.workspaces"/></xsl:otherwise>
            </xsl:choose>
        </h3>
    </xsl:template>
    
    <xsl:template name="as-project-title">
        <xsl:variable name="color" select="project:projectCategoryColor(projectName)"/>
        <a href="{projectUrl}" class="mb-0" style="color: {$color/main}">
            <i class="fas fa-dice-d6" aria-hidden="true"></i>
            <xsl:value-of select="projectTitle"/>
        </a>
    </xsl:template>
    
    <xsl:template name="as-event-date">
        <span class="ametys-notifications_time" data-momentdate="{date-iso}"></span>
    </xsl:template>
    
    <!-- New members -->
    <xsl:template match="events[type = 'member.added']" mode="event-body">
        <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_MEMBERS_ADDED_DESC" />
                    <i18n:param name="members"><xsl:call-template name="as-project-member"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_MEMBER_ADDED_DESC" />
                    <i18n:param name="member"><xsl:call-template name="as-project-member"/></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="as-project-member">
        <xsl:for-each select="members/members">
            <xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
            <xsl:value-of select="name" />
        </xsl:for-each>
    </xsl:template>
    <!-- // End New members -->
    
    <!-- New wall content -->
    <xsl:template match="events[type = 'wallcontent.added']" mode="event-body">
        <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_WALLCONTENT_ADDED_DESC" />
    </xsl:template>
    
    <xsl:template match="events[type = 'wallcontent.added']" mode="event-details">
        <span class="ametys-q-panel__list_subtx_icn"><xsl:value-of select="contentSummary"/></span>
    </xsl:template>
    <!-- // End new wall content -->
    
    <!-- Wall content commented -->
    <xsl:template match="events[type= 'content.comment.validated'][contentType = 'org.ametys.plugins.workspaces.Content.wallContent']" mode="event-body">
        <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_WALLCONTENT_COMMENTED_DESC" />
    </xsl:template>
    
    <xsl:template match="events[type= 'content.comment.validated'][contentType = 'org.ametys.plugins.workspaces.Content.wallContent']" mode="event-details">
        <span class="ametys-q-panel__list_subtx_icn"><i class="fas fa-comment-dots" aria-hidden="true"></i><xsl:value-of select="commentSummary"/></span>
    </xsl:template>
    <!-- // End wall content commented -->
    
    <!-- New documents -->
    <xsl:template match="events[type = 'resource.created']" mode="event-body">
        <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_DOCUMENT_ADDED_MULTI_DESC" />
                    <i18n:param name="author"/>
                    <i18n:param name="nb"><xsl:value-of select="count(files/files)"/></i18n:param>
                    <i18n:param name="folder"><strong><xsl:value-of select="parentFolder" /></strong></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_DOCUMENT_ADDED_DESC" />
                    <i18n:param name="author"/>
                    <i18n:param name="folder"><strong><xsl:value-of select="parentFolder" /></strong></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="events[type = 'resource.created' or type = 'resource.updated' or type = 'resource.renamed']" mode="event-details">
        <xsl:choose>
            <xsl:when test="count(files/files) > 3">
                <ul class="ametys-q-panel__list_subtxt--limit">
                    <xsl:for-each select="files/files">
                        <li>
                            <xsl:if test="position() > 2">
                                 <xsl:attribute name="aria-hidden">true</xsl:attribute>
                            </xsl:if>
                            <a href="{resolver:resolve('project-resource', id, true())}" class="ametys-q-panel__list_subtx_icn">
                                <xsl:if test="position() > 2">
                                    <xsl:attribute name="tabindex">-1</xsl:attribute>
                                </xsl:if>
                                <xsl:apply-templates select="." mode="file-icon"/>
                                <xsl:value-of select="name"/>
                            </a>
                        </li>
                    </xsl:for-each>
                </ul>
                <button class="ametys-voir-plus ametys-sidebar-voir"><i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_SEE_MORE" i18n:catalogue="plugin.workspaces"/></button>
            </xsl:when>
            <xsl:otherwise>
                <ul>
                    <xsl:for-each select="files/files">
                        <li>
                            <a href="{resolver:resolve('project-resource', id, true())}" class="ametys-q-panel__list_subtx_icn">
                                <xsl:apply-templates select="." mode="file-icon"/>
                                <xsl:value-of select="name"/>
                            </a>
                        </li>
                    </xsl:for-each>
                </ul>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- // End New documents -->
    
    <!-- Documents updated -->
    <xsl:template match="events[type = 'resource.updated']" mode="event-body">
        <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_DOCUMENT_UPDATED_MULTI_DESC" />
                    <i18n:param name="author"/>
                    <i18n:param name="nb"><xsl:value-of select="count(files/files)"/></i18n:param>
                    <i18n:param name="folder"><strong><xsl:value-of select="parentFolder" /></strong></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_DOCUMENT_UPDATED_DESC" />
                    <i18n:param name="author"/>
                    <i18n:param name="folder"><strong><xsl:value-of select="parentFolder" /></strong></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="events[type = 'resource.renamed']" mode="event-body">
        <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_DOCUMENT_RENAMED_MULTI_DESC" />
                    <i18n:param name="author"/>
                    <i18n:param name="nb"><xsl:value-of select="count(files/files)"/></i18n:param>
                    <i18n:param name="folder"><strong><xsl:value-of select="parentFolder" /></strong></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_DOCUMENT_RENAMED_DESC" />
                    <i18n:param name="author"/>
                    <i18n:param name="folder"><strong><xsl:value-of select="parentFolder" /></strong></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- // End Documents updated -->
    
    <!-- Document commented -->
    <xsl:template match="events[type = 'resource.commented']" mode="event-body">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_DOCUMENT_COMMENTED_DESC" />
            <i18n:param name="author"/>
            <i18n:param name="folder"><strong><xsl:value-of select="parentFolder" /></strong></i18n:param>
            <i18n:param name="filename"><strong><xsl:value-of select="files/files/name" /></strong></i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <xsl:template match="events[type = 'resource.commented']" mode="event-details">
        <xsl:for-each select="files/files">
            <!-- FIXME WORKSPACES-1354 use deep link here -->
            <span class="ametys-q-panel__list_subtx_icn">
                <i class="fas fa-comment-dots" aria-hidden="true"></i>
                <xsl:value-of select="../../commentSummary"/>
            </span>
        </xsl:for-each>
    </xsl:template>
    <!-- // End document commented -->
    
    <!-- New calendar events -->
    <xsl:template match="events[type = 'calendar.event.created']" mode="event-body">
        <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_CALENDAR_ADDED_MULTI_DESC" />
                    <i18n:param name="nb"><xsl:value-of select="count(events/events)"/></i18n:param>
                    <i18n:param name="calendar"><strong><xsl:value-of select="calendarTitle"/></strong></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_CALENDAR_ADDED_DESC" />
                    <i18n:param name="calendar"><strong><xsl:value-of select="calendarTitle"/></strong></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="events[type = 'calendar.event.updated']" mode="event-body">
        <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_CALENDAR_UPDATED_MULTI_DESC" />
                    <i18n:param name="nb"><xsl:value-of select="count(events/events)"/></i18n:param>
                    <i18n:param name="calendar"><strong><xsl:value-of select="calendarTitle"/></strong></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_CALENDAR_UPDATED_DESC" />
                    <i18n:param name="calendar"><strong><xsl:value-of select="calendarTitle"/></strong></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="events[type = 'calendar.event.deleting']" mode="event-body">
        <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_CALENDAR_DELETED_MULTI_DESC" />
                    <i18n:param name="nb"><xsl:value-of select="count(events/events)"/></i18n:param>
                    <i18n:param name="calendar"><strong><xsl:value-of select="calendarTitle"/></strong></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_CALENDAR_DELETED_DESC" />
                    <i18n:param name="calendar"><strong><xsl:value-of select="calendarTitle"/></strong></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="events[type = 'calendar.event.created']|events[type = 'calendar.event.updated']|events[type = 'calendar.event.deleting']" mode="event-details">
        <ul>
            <xsl:for-each select="events/events">
                <li>
                    <a href="{eventUrl}" class="ametys-q-panel__list_subtx_icn">
                        <i class="far fa-calendar" aria-hidden="true"></i>
                        <xsl:value-of select="eventTitle"/>
                    </a>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    <!-- // End New calendar events -->
    
    <!-- New task -->
    <xsl:template match="events[type = 'task.created']" mode="event-body">
         <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_TASK_ADDED_MULTI_DESC" />
                    <i18n:param name="nb"><xsl:value-of select="count(tasks/tasks)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_TASK_ADDED_DESC" />
            </xsl:otherwise>
         </xsl:choose>
    </xsl:template>
    <!-- //End New task -->

    <!-- Closed Task -->
    <xsl:template match="events[type = 'task.closed.status.changed']" mode="event-body">
        <xsl:choose>
            <xsl:when test="isClosed = 'true'">
                <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_TASK_CLOSED_DESC" />
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_TASK_NOT_CLOSED_DESC" />
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    <!-- End Closed Task -->
    
    <!-- Assignments Task -->
    <xsl:template match="events[type = 'task.assigned']" mode="event-body">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_TASK_ASSIGNED_DESC" />
            <i18n:param name="assignees"><strong><xsl:value-of select="assignees" /></strong></i18n:param>
        </i18n:translate>
    </xsl:template>
    <!-- End Assignments Task -->
    
    <!-- Task deleted -->
    <xsl:template match="events[type = 'task.deleting']" mode="event-body">
         <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_TASK_DELETING_MULTI_DESC" />
                    <i18n:param name="nb"><xsl:value-of select="count(tasks/tasks)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_TASK_DELETING_DESC" />
            </xsl:otherwise>
         </xsl:choose>
    </xsl:template>
    <!-- //End New task -->

<!--     Task details -->
    <xsl:template match="events[type = 'task.created' or type = 'task.closed.status.changed' or type = 'task.assigned' or type = 'task.deleting']" mode="event-details">
        <ul>
        <xsl:for-each select="tasks/tasks">
            <li>
                <a href="{taskUrl}" class="ametys-q-panel__list_subtx_icn">
                    <i class="fas fa-tasks" aria-hidden="true"></i>
                    <xsl:value-of select="taskTitle"/>
                </a>
            </li>
        </xsl:for-each>
        </ul>
    </xsl:template>
        
    <!-- Minisite page created -->
    <xsl:template match="events[type = 'minisite.page.created']" mode="event-body">
         <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_MINISITE_PAGE_CREATED_MULTI_DESC" />
                    <i18n:param name="nb"><xsl:value-of select="count(pages/pages)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_MINISITE_PAGE_CREATED_DESC" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- End minisite page created -->
    
    <!-- Minisite page updated -->
    <xsl:template match="events[type = 'minisite.page.updated']" mode="event-body">
         <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_MINISITE_PAGE_UPDATED_MULTI_DESC" />
                    <i18n:param name="nb"><xsl:value-of select="count(pages/pages)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_MINISITE_PAGE_UPDATED_DESC" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="events[type = 'minisite.page.updated' or type='minisite.page.created']" mode="event-details">
        <xsl:choose>
            <xsl:when test="count(pages/pages) > 3">
                <ul class="ametys-q-panel__list_subtxt--limit">
                    <xsl:for-each select="pages/pages">
                        <li>
                            <xsl:if test="position() > 2">
                                 <xsl:attribute name="aria-hidden">true</xsl:attribute>
                            </xsl:if>
                            <a href="{resolver:resolve('page', pageId)}" class="ametys-q-panel__list_subtx_icn">
                                <xsl:if test="position() > 2">
                                    <xsl:attribute name="tabindex">-1</xsl:attribute>
                                </xsl:if>
                                <i class="fas fa-file" aria-hidden="true"></i>
                                <xsl:value-of select="pageTitle"/>
                            </a>
                        </li>
                    </xsl:for-each>
                </ul>
                <button class="ametys-voir-plus ametys-sidebar-voir"><i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_SEE_MORE" i18n:catalogue="plugin.workspaces"/></button>
            </xsl:when>
            <xsl:otherwise>
                <ul>
                    <xsl:for-each select="pages/pages">
                        <li>
                            <a href="{resolver:resolve('page', pageId)}" class="ametys-q-panel__list_subtx_icn">
                                <i class="fas fa-file" aria-hidden="true"></i>
                                <xsl:value-of select="pageTitle"/>
                            </a>
                        </li>
                    </xsl:for-each>
                </ul>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- End minisite page updated -->
    
    <!-- Minisite page deleted -->
    <xsl:template match="events[type = 'minisite.page.deleted']" mode="event-body">
         <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_MINISITE_PAGE_DELETED_MULTI_DESC" />
                    <i18n:param name="nb"><xsl:value-of select="count(pages/pages)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_MINISITE_PAGE_DELETED_DESC" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="events[type = 'minisite.page.deleted']" mode="event-details">
        <xsl:choose>
            <xsl:when test="count(pages/pages) > 3">
                <ul class="ametys-q-panel__list_subtxt--limit">
                    <xsl:for-each select="pages/pages">
                        <li>
                            <xsl:if test="position() > 2">
                                 <xsl:attribute name="aria-hidden">true</xsl:attribute>
                            </xsl:if>
                            <span class="ametys-q-panel__list_subtx_icn">
                                <i class="fas fa-file" aria-hidden="true"></i>
                                <xsl:value-of select="pageTitle"/>
                            </span>
                        </li>
                    </xsl:for-each>
                </ul>
                <button class="ametys-voir-plus ametys-sidebar-voir"><i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_SEE_MORE" i18n:catalogue="plugin.workspaces"/></button>
            </xsl:when>
            <xsl:otherwise>
                <ul>
                    <xsl:for-each select="pages/pages">
                        <li>
                            <span class="ametys-q-panel__list_subtx_icn">
                                <i class="fas fa-file" aria-hidden="true"></i>
                                <xsl:value-of select="pageTitle"/>
                            </span>
                        </li>
                    </xsl:for-each>
                </ul>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- End minisite page deleted -->
    
    <!-- Minisite page renamed -->
    <xsl:template match="events[type = 'minisite.page.renamed']" mode="event-body">
         <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_MINISITE_PAGE_RENAMED_DESC" />
    </xsl:template>
    
    <xsl:template match="events[type = 'minisite.page.renamed']" mode="event-details">
        <a href="{resolver:resolve('page', pageId)}" class="ametys-q-panel__list_subtx_icn">
            <i class="fas fa-file" aria-hidden="true"></i>
            <xsl:value-of select="pageTitle"/>
        </a>
    </xsl:template>
    <!-- End minisite page updated -->
    
    <!-- News publication -->
    <xsl:template match="events[type = 'project.news.published']" mode="event-body">
        <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_NEWS_PUBLISHED_DESC" />
    </xsl:template>
    
    <xsl:template match="events[type = 'project.news.published']" mode="event-details">
        <span class="ametys-q-panel__list_subtx_icn"><xsl:value-of select="contentSummary"/></span>
        <a href="{resolver:resolve('page', pageId)}" class="ametys-q-panel__list_subtx_icn">
            <i class="fas fa-file-alt" aria-hidden="true"></i>
            <xsl:value-of select="contentTitle"/>
        </a>
    </xsl:template>
    <!-- End news publication -->
    
    <!-- News commented -->
    <xsl:template match="events[type= 'content.comment.validated'][contentType = 'org.ametys.plugins.workspaces.Content.projectNews']" mode="event-body">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_NEWS_COMMENTED_DESC" />
            <i18n:param name="news">
                <strong>
                    <xsl:value-of select="contentTitle"/>
                </strong>
            </i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <xsl:template match="events[type= 'content.comment.validated'][contentType = 'org.ametys.plugins.workspaces.Content.projectNews']" mode="event-details">
        <a href="{resolver:resolve('page', pageId)}" class="ametys-q-panel__list_subtx_icn">
            <i class="fas fa-comment-dots" aria-hidden="true"></i>
            <xsl:value-of select="commentSummary"/>
        </a>
    </xsl:template>
    <!-- // End news commented -->
    
    
    <!-- New forum thread -->
    <xsl:template match="events[type = 'forumthread.created']" mode="event-body">
         <xsl:choose>
            <xsl:when test="amount > 1">
                <i18n:translate>
                    <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_FORUMTHREAD_CREATED_MULTI_DESC" />
                    <i18n:param name="nb"><xsl:value-of select="count(threads/threads)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_FORUMTHREAD_CREATED_DESC" />
            </xsl:otherwise>
         </xsl:choose>
    </xsl:template>
    
    <xsl:template match="events[type = 'forumthread.created' or type = 'forumthread.modified' or type = 'forumthread.closed' or type = 'forumthread.deleted']" mode="event-details">
        <ul>
            <xsl:for-each select="threads/threads">
                <li>
                    <a href="{threadUrl}" class="ametys-q-panel__list_subtx_icn">
                        <i class="fas fa-comments" aria-hidden="true"></i>
                        <xsl:value-of select="threadTitle"/>
                    </a>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <!-- Modified thread -->
    <xsl:template match="events[type = 'forumthread.modified']" mode="event-body">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_FORUMTHREAD_MODIFIED_DESC" />
            <i18n:param name="thread"><strong><xsl:value-of select="threadTitle"/></strong></i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <!-- Closed thread -->
    <xsl:template match="events[type = 'forumthread.closed']" mode="event-body">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_FORUMTHREAD_CLOSED_DESC" />
            <i18n:param name="thread"><strong><xsl:value-of select="threadTitle"/></strong></i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <!-- Deleted thread -->
    <xsl:template match="events[type = 'forumthread.deleted']" mode="event-body">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_ACTIVITY_STREAM_EVENT_FORUMTHREAD_DELETED_DESC" />
            <i18n:param name="thread"><strong><xsl:value-of select="threadTitle"/></strong></i18n:param>
        </i18n:translate>
    </xsl:template>
        
    <!-- New comment -->
    <xsl:template match="events[type = 'forumthread.commented']" mode="event-body">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_THREAD_POST_CREATED_DESC" />
            <i18n:param name="thread"><strong><xsl:value-of select="threadTitle"/></strong></i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <xsl:template match="events[type = 'forumthread.commented']" mode="event-details">
        <a href="{threadUrl}" class="ametys-q-panel__list_subtx_icn">
            <i class="fas fa-comment-dots" aria-hidden="true"></i>
            <xsl:value-of select="content" disable-output-escaping="yes"/>
        </a>
    </xsl:template>
    
    <!-- Accepted comment -->
    <xsl:template match="events[type = 'forumthread.accepted']" mode="event-body">
        <i18n:translate>
            <i18n:text i18n:catalogue="plugin.workspaces" i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_ACTIVITY_STREAM_EVENT_THREAD_POST_ACCEPTED_DESC" />
            <i18n:param name="thread"><strong><xsl:value-of select="threadTitle"/></strong></i18n:param>
        </i18n:translate>
    </xsl:template>
    
    <xsl:template match="events[type = 'forumthread.accepted']" mode="event-details">
        <a href="{threadUrl}" class="ametys-q-panel__list_subtx_icn">
            <i class="fas fa-comment-dots" aria-hidden="true"></i>
            <xsl:value-of select="content" disable-output-escaping="yes"/>
        </a>
    </xsl:template>
    
    <xsl:template match="events" mode="event-body">
        <p>NOT YET IMPLEMENTED: <xsl:value-of select="type"/></p>
    </xsl:template>
    
    <xsl:template match="events" mode="event-details">
    </xsl:template>
    
    <!-- Files icons -->
    <xsl:template match="files[mimeType='application/pdf']" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/applicationpdf.svg')}"  alt=""></img>
    </xsl:template>
    <xsl:template match="files[starts-with(mimeType, 'image/')]" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/image.svg')}" alt=""></img>
    </xsl:template>
    <xsl:template match="files[mimeType='application/msword' or mimeType='application/rtf' or contains(mimeType, 'wordprocessingml')]" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/xofficedocument.svg')}" alt=""></img>
    </xsl:template>
    <xsl:template match="files[mimeType='application/vnd.ms-excel' or mimeType='text/csv' or contains(mimeType, 'spreadsheet')]" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/xofficespreadsheet.svg')}" alt=""></img>
    </xsl:template>
    <xsl:template match="files[mimeType='application/vnd.ms-powerpoint' or contains(mimeType, 'presentation')]" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/xofficepresentation.svg')}" alt=""></img>
    </xsl:template>
    <xsl:template match="files[starts-with(mimeType, 'video/')]" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/video.svg')}" alt=""></img>
    </xsl:template>
    <xsl:template match="files[starts-with(mimeType, 'audio/')]" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/audio.svg')}" alt=""></img>
    </xsl:template>
    <xsl:template match="files[mimeType='text/plain']" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/textxchangelog.svg')}"></img>
    </xsl:template>
    <xsl:template match="files[mimeType='application/zip' or mimeType='application/x-7z-compressed' or mimeType='application/x-tar' or mimeType='application/x-rar-compressed']" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/archive.svg')}" alt=""></img>
    </xsl:template>
    <xsl:template match="files" mode="file-icon">
        <img src="{ametys:pluginResourceURL('workspaces', 'img/file-icons/unknown.svg')}" alt=""></img>
    </xsl:template>
    <!-- // End Files icons -->
    
    <xsl:template name="author-img-url">
        <xsl:param name="login"/><!-- user's login -->
        <xsl:param name="population"/><!-- user's population id -->
        <xsl:param name="imgWidth">42</xsl:param>                                            <!-- dimension of user's avatar -->
        <xsl:value-of select="concat($site-uri-prefix, '/_plugins/core-ui/user/', $population, '/', uriutils:encodePath($login), '/image_', $imgWidth, '?lang=', $lang)"/>
    </xsl:template>
    
</xsl:stylesheet>