<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent">
                              
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>

    <xsl:template name="title">
        <xsl:variable name="titleKey">
            <xsl:choose>
                <xsl:when test="activity/memberType = 'user'">PROJECT_MAIL_NOTIFICATION_BODY_USER_<xsl:value-of select="/notification/eventKey"/>_TITLE</xsl:when>
                <xsl:when test="activity/memberType = 'group'">PROJECT_MAIL_NOTIFICATION_BODY_GROUP_<xsl:value-of select="/notification/eventKey"/>_TITLE</xsl:when>
            </xsl:choose>
        </xsl:variable>
        <!-- It's not possible to set the attribute of an html element of the i18n key with a i18n param
            It will be done by the XSL after. Provide the data in an attribute of the title element here.
            In the i18n key, set the name of this attribute in an attribute data-href of the a element.
            The rest will be done by the skin -->
        <title root-data="true" projectURL="{project/url}">
            <i18n:translate>
                <i18n:text i18n:key="{$titleKey}" i18n:catalogue="plugin.workspaces"/>
                <i18n:param name="issuerFullname"><xsl:value-of select="issuer/user/fullname"/></i18n:param>
                <i18n:param name="projectTitle"><xsl:value-of select="project/title"/></i18n:param>
            </i18n:translate>
        </title>
    </xsl:template>

    <xsl:template match="activity">
        <item type="member">    
            <xsl:apply-templates select="." mode="title"/>
            <xsl:apply-templates select="." mode="author"/>
            <xsl:apply-templates select="." mode="date"/>
            <xsl:apply-templates select="." mode="memberType"/>
            <xsl:apply-templates select="." mode="identity"/>
            <eventType><xsl:value-of select="/notification/eventKey"/></eventType>
        </item>
    </xsl:template>
    
    <xsl:template match="activity" mode="title">
        <title>
            <xsl:choose>
                <xsl:when test="../user"><xsl:value-of select="../user/fullname"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="../group/label"/></xsl:otherwise>
            </xsl:choose>
        </title>
    </xsl:template>
    
    <xsl:template match="activity" mode="memberType">
        <memberType>
            <xsl:value-of select="memberType"/>
        </memberType>
    </xsl:template>
    
    <xsl:template match="activity" mode="identity">
        <identity>
            <xsl:value-of select="member"/>
        </identity>
    </xsl:template>
    
</xsl:stylesheet>