<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <!-- +
         | Helper to diplay a simple text for more items count
         + -->
    <xsl:template name="more">
        <xsl:param name="width" select="$max-width - 60"/>
        <xsl:param name="margin-top">10</xsl:param>
        <xsl:param name="margin-bottom">20</xsl:param>
        <xsl:param name="padding-left">20</xsl:param>
        <xsl:param name="padding-right">20</xsl:param>
        <xsl:param name="text"/>
        
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
    
        <div style="max-width: {$width}px; margin: 0px auto">
            <table>
                <xsl:call-template name="table-layout-attributes" />
                <tbody>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-top" />
                        <xsl:with-param name="colspan">3</xsl:with-param>
                    </xsl:call-template>
                    <tr>
                        <xsl:call-template name="row-horizontal-spacer">
                            <xsl:with-param name="width" select="$padding-left" />
                        </xsl:call-template>
                    
                        <td>
                            <xsl:call-template name="td-layout-attributes" />

                            <div>
                                <xsl:call-template name="text-style"/>
                                <xsl:value-of select="$text" disable-output-escaping="yes"/>
                            </div>
                        </td>
                        
                        <xsl:call-template name="row-horizontal-spacer">
                            <xsl:with-param name="width" select="$padding-right" />
                        </xsl:call-template>
                    </tr>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-bottom" />
                        <xsl:with-param name="colspan">3</xsl:with-param>
                    </xsl:call-template>
                </tbody>
            </table>
        </div>
        <xsl:call-template name="msoif-close" />
    </xsl:template>
    
</xsl:stylesheet>