<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:import href="item-common.xsl"/>
    <xsl:import href="item-calendar.xsl"/>
    <xsl:import href="item-content.xsl"/>
    <xsl:import href="item-resource.xsl"/>
    <xsl:import href="item-task.xsl"/>
    <xsl:import href="item-member.xsl"/>
    <xsl:import href="item-project.xsl"/>
    <xsl:import href="item-page.xsl"/>
    <xsl:import href="item-forum.xsl"/>
    
    <xsl:template match="items">
        <xsl:variable name="background-color">
            <xsl:choose>
                <xsl:when test="nobg"><xsl:value-of select="$content-bg-color"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$grey-light"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="items-container">
            <xsl:with-param name="inner-content">
                <xsl:apply-templates select="item"/>
                <xsl:apply-templates select="more"/>
            </xsl:with-param>
            <xsl:with-param name="background-color" select="$background-color"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="more">
        <xsl:call-template name="more">
            <xsl:with-param name="text" select="."/>
        </xsl:call-template>
    </xsl:template>
</xsl:stylesheet>