/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.categories;

import java.util.Map;
import java.util.stream.Collectors;

import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.tag.ColorableCMSTag;
import org.ametys.cms.tag.TagTargetType;

/**
 * This class represent a project category as a CMS Tag
 */
public class CategoryCMSTag extends ColorableCMSTag
{
    /** The prefix for all tags issue from categories */
    public static final String TAG_PREFIX = "WORKSPACES_CATEGORY_";
    
    private Category _category;
    
    /**
     * Constructor
     * @param category the category
     * @param parent the parent CMS tag
     * @param targetType the target type
     */
    public CategoryCMSTag(Category category, CMSTag parent, TagTargetType targetType)
    {
        super(new CMSTag(TAG_PREFIX + category.getName(), TAG_PREFIX + category.getName(), parent, category.getTitle(), category.getDescription(), TagVisibility.PUBLIC, targetType, 0), category.getColor(false), category.getColorComponent());
        _category = category;
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public ColorableCMSTag getTag(String tagId)
    {
        Category category = _category.getTag(tagId);
        return new CategoryCMSTag(category, this, this.getTarget());
    }
    
    
    @Override
    public Map<String, CMSTag> getTags()
    {
        return _category.getTags().values()
            .stream()
            .map(category -> new CategoryCMSTag(category, this, this.getTarget()))
            .collect(Collectors.toMap(tag -> tag.getId(), tag -> tag));
    }
}
