/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.documents.jcr;

import javax.jcr.Node;

import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollection;
import org.ametys.plugins.repository.AmetysObject;

/**
 * Implementation of a {@link JCRResourcesCollection} that handles {@link File}s, backed by a JCR node.<br>
 */
public class Folder extends JCRResourcesCollection<FolderFactory>
{

    /**
     * Creates an {@link Folder}.
     * @param node the node backing this {@link AmetysObject}
     * @param parentPath the parentPath in the Ametys hierarchy
     * @param factory the DefaultAmetysObjectFactory which created the AmetysObject
     */
    public Folder(Node node, String parentPath, FolderFactory factory)
    {
        super(node, parentPath, factory);
    }

    @Override
    public String getResourceType()
    {
        return FileFactory.FILE_NODETYPE;
    }

    @Override
    public String getCollectionType()
    {
        return FolderFactory.FOLDER_NODETYPE;
    }
    
}
