/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.generators;

import java.io.IOException;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.workspaces.forum.ThreadCategoryEnum;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Generator for the vuejs forum service 
 */
public class ProjectsForumGenerator extends ServiceableGenerator
{
    
    public void generate() throws IOException, SAXException, ProcessingException
    {
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "forum");

        _saxThreadCategories();
        
        XMLUtils.endElement(contentHandler, "forum");
        contentHandler.endDocument();
    }

    private void _saxThreadCategories() throws SAXException
    {
        XMLUtils.startElement(contentHandler, "threadCategories");

        for (ThreadCategoryEnum threadCategory : ThreadCategoryEnum.values())
        {
            XMLUtils.startElement(contentHandler, "threadCategory");
            
            XMLUtils.createElement(contentHandler, "threadCategoryName", threadCategory.name());
            new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_FORUM_THREAD_CATEGORY_" + threadCategory.name()).toSAX(contentHandler, "threadCategoryLabel");

            XMLUtils.endElement(contentHandler, "threadCategories");
        }

        XMLUtils.endElement(contentHandler, "threadCategories");
    }

}
