/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.List;
import java.util.stream.Stream;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityNotifier;
import org.ametys.plugins.workspaces.activities.documents.AbstractDocumentsActivityType;
import org.ametys.plugins.workspaces.activities.documents.DocumentCommentedActivityType;
import org.ametys.plugins.workspaces.activities.documents.ResourceCreatedOrUpdatedActivityType;
import org.ametys.plugins.workspaces.activities.documents.ResourceReferenceElementType;
import org.ametys.plugins.workspaces.activities.documents.ResourceRenamedActivityType;

public class DocumentsActivityNotifier
extends AbstractWorkspacesActivityNotifier {
    public boolean supports(ActivityType activityType) {
        return activityType instanceof DocumentCommentedActivityType || activityType instanceof ResourceCreatedOrUpdatedActivityType || activityType instanceof ResourceRenamedActivityType;
    }

    @Override
    public String getMailBodyURI(Activity activity) {
        return "cocoon://_plugins/workspaces/notification-mail-resource";
    }

    @Override
    protected String _getSubjectI18nKey(Activity activity) {
        ResourceReferenceElementType.ResourceReference[] refs;
        Object i18nKey = super._getSubjectI18nKey(activity);
        if (activity.getActivityType() instanceof AbstractDocumentsActivityType && activity.hasValue("files") && (refs = (ResourceReferenceElementType.ResourceReference[])activity.getValue("files")).length > 1) {
            i18nKey = (String)i18nKey + "_MULTIPLE";
        }
        return i18nKey;
    }

    @Override
    public List<String> getSubjectI18nParams(Activity activity) {
        List<String> i18nParams = super.getSubjectI18nParams(activity);
        if (activity.hasValue("file")) {
            ResourceReferenceElementType.ResourceReference ref = (ResourceReferenceElementType.ResourceReference)activity.getValue("file");
            i18nParams.add(ref.oldName() != null ? ref.oldName() : ref.name());
        } else if (activity.hasValue("files")) {
            ResourceReferenceElementType.ResourceReference[] refs = (ResourceReferenceElementType.ResourceReference[])activity.getValue("files");
            if (refs.length > 1) {
                i18nParams.add(String.valueOf(refs.length));
            } else {
                i18nParams.add(Stream.of(refs).findFirst().map(ResourceReferenceElementType.ResourceReference::name).orElse(""));
            }
        }
        return i18nParams;
    }

    @Override
    public AmetysObject getTargetAmetysObject(Activity activity) {
        return this._resolver.resolveById((String)activity.getValue("parentFolderId"));
    }
}

