/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.HashSet;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.ametys.core.observation.Event;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.documents.AbstractDocumentsActivityType;
import org.ametys.plugins.workspaces.activities.documents.ResourceReferenceElementType;
import org.ametys.plugins.workspaces.project.notification.ResourceNotifierHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ResourceCreatedOrUpdatedActivityType
extends AbstractDocumentsActivityType {
    private ResourceNotifierHelper _resourceNotifierHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resourceNotifierHelper = (ResourceNotifierHelper)serviceManager.lookup(ResourceNotifierHelper.ROLE);
    }

    public boolean supports(Event event) {
        return !event.getId().equals("resource.updated") || this._isResourceRecentlyModified(event);
    }

    private boolean _isResourceRecentlyModified(Event event) {
        String resourceId = event.getArguments().getOrDefault("object.id", null);
        return !this._resourceNotifierHelper.resourceRecentlyModified(resourceId);
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        HashSet<Object> resourceIds = new HashSet<Object>();
        if (parameters.containsKey("resources")) {
            resourceIds.addAll(((Map)parameters.get("resources")).keySet());
        } else {
            resourceIds.add((String)parameters.get("object.id"));
        }
        ResourceReferenceElementType.ResourceReference[] references = new ResourceReferenceElementType.ResourceReference[resourceIds.size()];
        int i = 0;
        for (String string : resourceIds) {
            JCRResource resource = (JCRResource)this._ametysObjectResolver.resolveById(string);
            Node resourceNode = resource.getNode();
            VersionManager versionManager = resourceNode.getSession().getWorkspace().getVersionManager();
            Version baseVersion = versionManager.getBaseVersion(resourceNode.getPath());
            references[i] = new ResourceReferenceElementType.ResourceReference(string, resource.getName(), null, resource.getMimeType(), baseVersion.getName());
            ++i;
        }
        activity.setValue("files", (Object)references);
    }

    @Override
    public Map<String, Object> additionnalDataToJSONForClient(Activity activity) {
        Map<String, Object> json = super.additionnalDataToJSONForClient(activity);
        String projectName = (String)activity.getValue("projectName");
        Project project = this._projectManager.getProject(projectName);
        ResourceReferenceElementType.ResourceReference[] refs = (ResourceReferenceElementType.ResourceReference[])activity.getValue("files");
        if (refs.length == 1) {
            String id = refs[0].id();
            json.put("fileUrl", this._documentModule.getFileUri(project, id));
        } else {
            json.put("fileUrl", this._documentModule.getModuleUrl(project));
        }
        return json;
    }
}

