/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.documents.AbstractDocumentsActivityType;
import org.ametys.plugins.workspaces.activities.documents.ResourceReferenceElementType;
import org.ametys.plugins.workspaces.project.objects.Project;

public class ResourceRenamedActivityType
extends AbstractDocumentsActivityType {
    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        String resourceName = (String)parameters.get("object.name");
        String resourceOldName = (String)parameters.get("object.old.name");
        String resourceId = (String)parameters.get("object.id");
        JCRResource resource = (JCRResource)this._ametysObjectResolver.resolveById(resourceId);
        activity.setValue("file", (Object)new ResourceReferenceElementType.ResourceReference(resourceId, resourceName, resourceOldName, resource.getMimeType(), null));
    }

    @Override
    public Map<String, Object> additionnalDataToJSONForClient(Activity activity) {
        Map<String, Object> json = super.additionnalDataToJSONForClient(activity);
        String projectName = (String)activity.getValue("projectName");
        Project project = this._projectManager.getProject(projectName);
        if (project != null) {
            ResourceReferenceElementType.ResourceReference ref = (ResourceReferenceElementType.ResourceReference)activity.getValue("file");
            json.put("fileUrl", this._documentModule.getFileUri(project, ref.id()));
        }
        return json;
    }
}

