/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.tasks;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.cms.repository.mentions.MentionUtils;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.tasks.TasksActivityType;
import org.ametys.plugins.workspaces.tasks.Task;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class TasksCommentedActivityType
extends TasksActivityType {
    public static final String CREATION_FATE = "creationDate";
    public static final String TASK_AUTHOR = "taskAuthor";
    public static final String COMMENT_SUMMARY = "commentSummary";
    public static final String COMMENT_CREATIONDATE = "commentCreationDate";
    protected MentionUtils _mentionUtils;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._mentionUtils = (MentionUtils)manager.lookup(MentionUtils.ROLE);
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        String commentId = (String)parameters.get("taskCommentId");
        Task task = (Task)parameters.get("task");
        Comment comment = (Comment)task.getComment(commentId);
        activity.setValue(COMMENT_CREATIONDATE, (Object)comment.getCreationDate());
        activity.setValue(CREATION_FATE, (Object)task.getCreationDate(), "datetime");
        activity.setValue(TASK_AUTHOR, (Object)task.getAuthor(), "user");
        String commentValue = (String)parameters.get("taskComment");
        activity.setValue(COMMENT_SUMMARY, (Object)StringUtils.abbreviate((String)commentValue, (String)"\u2026", (int)150));
    }

    @Override
    public boolean isMergeable(Activity activity1, Activity activity2) {
        return false;
    }
}

