/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.task;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollection;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.ModifiableCalendar;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventOccurrence;
import org.ametys.plugins.workspaces.calendars.task.TaskCalendarEvent;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tasks.Task;
import org.ametys.plugins.workspaces.tasks.WorkspaceTaskDAO;
import org.apache.commons.lang3.StringUtils;

public class TaskCalendar
implements ModifiableCalendar {
    public static final String TASK_CALENDAR_DISABLED_ATTR = "taskCalendarDisabled";
    public static final String TASK_CALENDAR_NAME_ATTR = "taskCalendarName";
    public static final String TASK_CALENDAR_TOKEN_ATTR = "taskCalendarToken";
    public static final String TASK_CALENDAR_VISIBILITY_ATTR = "taskCalendarVisibility";
    public static final String TASK_CALENDAR_COLOR_ATTR = "taskCalendarColor";
    private WorkspaceTaskDAO _taskDAO;
    private Project _project;
    private JCRResourcesCollection _calendarModuleRoot;

    public TaskCalendar(Project project, JCRResourcesCollection calendarModuleRoot, WorkspaceTaskDAO taskDAO) {
        this._project = project;
        this._taskDAO = taskDAO;
        this._calendarModuleRoot = calendarModuleRoot;
    }

    public boolean isDisabled() {
        return (Boolean)this._calendarModuleRoot.getValue(TASK_CALENDAR_DISABLED_ATTR, (Object)false);
    }

    public void disable(boolean disabled) {
        this._calendarModuleRoot.setValue(TASK_CALENDAR_DISABLED_ATTR, (Object)disabled);
        this._calendarModuleRoot.saveChanges();
    }

    @Override
    public String getId() throws AmetysRepositoryException {
        return TaskCalendar.class.getName();
    }

    @Override
    public String getName() throws AmetysRepositoryException {
        return (String)this._calendarModuleRoot.getValue(TASK_CALENDAR_NAME_ATTR, (Object)"");
    }

    @Override
    public void rename(String name) {
        this._calendarModuleRoot.setValue(TASK_CALENDAR_NAME_ATTR, (Object)name);
        this._calendarModuleRoot.saveChanges();
    }

    @Override
    public Project getProject() {
        return this._project;
    }

    @Override
    public String getColor() {
        return (String)this._calendarModuleRoot.getValue(TASK_CALENDAR_COLOR_ATTR, (Object)"col1");
    }

    @Override
    public void setColor(String color) {
        this._calendarModuleRoot.setValue(TASK_CALENDAR_COLOR_ATTR, (Object)color);
        this._calendarModuleRoot.saveChanges();
    }

    @Override
    public Calendar.CalendarVisibility getVisibility() {
        return Calendar.CalendarVisibility.valueOf((String)this._calendarModuleRoot.getValue(TASK_CALENDAR_VISIBILITY_ATTR, (Object)Calendar.CalendarVisibility.PRIVATE.name()));
    }

    @Override
    public void setVisibility(Calendar.CalendarVisibility visibility) {
        this._calendarModuleRoot.setValue(TASK_CALENDAR_VISIBILITY_ATTR, (Object)visibility.name());
        this._calendarModuleRoot.saveChanges();
    }

    @Override
    public String getIcsUrlToken() {
        String token = (String)this._calendarModuleRoot.getValue(TASK_CALENDAR_TOKEN_ATTR);
        if (StringUtils.isBlank((CharSequence)token)) {
            token = UUID.randomUUID().toString();
            this.setIcsUrlToken(token);
        }
        return token;
    }

    @Override
    public void setIcsUrlToken(String token) {
        this._calendarModuleRoot.setValue(TASK_CALENDAR_TOKEN_ATTR, (Object)token);
        this._calendarModuleRoot.saveChanges();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void setDescription(String desc) {
    }

    @Override
    public String getTemplateDescription() {
        return null;
    }

    @Override
    public void setTemplateDescription(String templateDesc) {
    }

    @Override
    public List<Calendar> getChildCalendars() {
        return List.of();
    }

    @Override
    public List<CalendarEvent> getAllEvents() {
        if (this.isDisabled()) {
            return List.of();
        }
        return this._taskDAO.getProjectTasks(this._project).stream().filter(t -> t.getStartDate() != null || t.getDueDate() != null).map(t -> new TaskCalendarEvent(this, (Task)t)).map(CalendarEvent.class::cast).toList();
    }

    @Override
    public Map<CalendarEvent, List<CalendarEventOccurrence>> getEvents(ZonedDateTime startDate, ZonedDateTime endDate) {
        HashMap<CalendarEvent, List<CalendarEventOccurrence>> events = new HashMap<CalendarEvent, List<CalendarEventOccurrence>>();
        for (CalendarEvent event : this.getAllEvents()) {
            List<CalendarEventOccurrence> occurences = event.getOccurrences(startDate, endDate);
            if (occurences.isEmpty()) continue;
            events.put(event, occurences);
        }
        return events;
    }
}

