/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.search.query.DocumentTypeQuery;
import org.ametys.cms.search.query.FilenameQuery;
import org.ametys.cms.search.query.FullTextQuery;
import org.ametys.cms.search.query.MatchAllQuery;
import org.ametys.cms.search.query.MimeTypeGroupQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.cms.search.solr.SearcherFactory;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.ai.AIHelper;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.explorer.resources.ModifiableResource;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.explorer.resources.actions.AddOrUpdateResourceHelper;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.JCRTraversableAmetysObject;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.tag.TagAwareAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObject;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.documents.WorkspaceFileAIHelper;
import org.ametys.plugins.workspaces.documents.jcr.File;
import org.ametys.plugins.workspaces.documents.jcr.Folder;
import org.ametys.plugins.workspaces.documents.onlyoffice.OnlyOfficeManager;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.plugins.workspaces.search.query.KeywordQuery;
import org.ametys.plugins.workspaces.search.query.ProjectQuery;
import org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraphProperties;
import org.docx4j.dml.ObjectFactory;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.wml.Styles;
import org.pptx4j.pml.Presentation;

public class WorkspaceExplorerResourceDAO
extends ExplorerResourcesDAO {
    public static final String ROLE = WorkspaceExplorerResourceDAO.class.getName();
    public static final String RIGHTS_RESOURCE_COMMENT = "Plugin_Explorer_File_Comment";
    protected AddOrUpdateResourceHelper _addOrUpdateResourceHelper;
    private ProjectManager _projectManager;
    private SearcherFactory _searcherFactory;
    private WorkspaceModuleExtensionPoint _moduleEP;
    private WorkspacesHelper _workspaceHelper;
    private OnlyOfficeManager _onlyOfficeManager;
    private ProjectTagProviderExtensionPoint _tagProviderExtensionPoint;
    private I18nUtils _i18nUtils;
    private ProjectRightHelper _projectRightsHelper;
    private WorkspaceFileAIHelper _workspaceFileAIHelper;
    private AIHelper _aiHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._addOrUpdateResourceHelper = (AddOrUpdateResourceHelper)manager.lookup(AddOrUpdateResourceHelper.ROLE);
        this._searcherFactory = (SearcherFactory)manager.lookup(SearcherFactory.ROLE);
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._onlyOfficeManager = (OnlyOfficeManager)((Object)manager.lookup(OnlyOfficeManager.ROLE));
        this._tagProviderExtensionPoint = (ProjectTagProviderExtensionPoint)((Object)manager.lookup(ProjectTagProviderExtensionPoint.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._projectRightsHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        if (manager.hasService(WorkspaceFileAIHelper.ROLE)) {
            this._workspaceFileAIHelper = (WorkspaceFileAIHelper)((Object)manager.lookup(WorkspaceFileAIHelper.ROLE));
            this._aiHelper = (AIHelper)manager.lookup(AIHelper.ROLE);
        }
    }

    @Callable(rights={""})
    public Map<String, Object> addFolder(String parentId, String inputName, String description) {
        return this.addFolder(parentId, inputName, description, false);
    }

    @Callable(rights={""})
    public Map<String, Object> addFolder(String parentId, String inputName, String description, Boolean renameIfExists) {
        ResourceCollection document = this._getRootIfNull(parentId);
        if (document == null) {
            throw new IllegalArgumentException("Unable to add folder: parent folder not found");
        }
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_Folder_Add", (Object)document) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to add folder without convenient right [Plugin_Explorer_Folder_Add]");
        }
        if (!(document instanceof ModifiableResourceCollection)) {
            throw new IllegalArgumentException("Cannot add folder on a non-modifiable folder '" + parentId + "'");
        }
        LinkedList errors = new LinkedList();
        ResourceCollection collection = this.addResourceCollection((ModifiableResourceCollection)document, inputName, renameIfExists, errors);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!errors.isEmpty()) {
            result.put("message", errors.get(0));
            result.put("error", true);
        }
        if (collection != null) {
            if (StringUtils.isNotBlank((CharSequence)description)) {
                ((ModifiableResourceCollection)collection).setDescription(description);
            }
            ((ModifiableResourceCollection)collection).saveChanges();
            result.putAll(this._extractFolderData(collection));
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> moveObjects(List<String> objectIds, String parentFolderId) throws RepositoryException {
        JCRResourcesCollection parentFolder = (JCRResourcesCollection)this._resolver.resolveById(parentFolderId);
        for (String id : objectIds) {
            AmetysObject object = this._resolver.resolveById(id);
            String addRightId = object instanceof Resource ? "Plugin_Explorer_File_Add" : "Plugin_Explorer_Folder_Add";
            String deleteRightId = object instanceof Resource ? "Plugin_Explorer_File_Delete" : "Plugin_Explorer_Folder_Delete";
            ResourceCollection oldParent = (ResourceCollection)object.getParent();
            if (this._rightManager.hasRight(this._currentUserProvider.getUser(), addRightId, (Object)parentFolder) == RightManager.RightResult.RIGHT_ALLOW && this._rightManager.hasRight(this._currentUserProvider.getUser(), deleteRightId, (Object)oldParent) == RightManager.RightResult.RIGHT_ALLOW) continue;
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to move resource without convenient rights");
        }
        Map results = this.moveObject(objectIds, (JCRTraversableAmetysObject)parentFolder);
        if (results.containsKey("moved-objects")) {
            ArrayList<String> movedFolders = new ArrayList<String>();
            ArrayList<String> movedFiles = new ArrayList<String>();
            List movedObjects = (List)results.get("moved-objects");
            for (String objectId : movedObjects) {
                AmetysObject object = this._resolver.resolveById(objectId);
                if (object instanceof Folder) {
                    movedFolders.add(objectId);
                    continue;
                }
                movedFiles.add(objectId);
            }
            results.put("moved-folders", movedFolders);
            results.put("moved-files", movedFiles);
        }
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> renameFolder(String id, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Folder folder = (Folder)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_Folder_Edit", (Object)folder) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to edit folder without convenient right [Plugin_Explorer_Folder_Edit]");
        }
        LinkedList<String> errors = new LinkedList<String>();
        Folder newFolder = null;
        try {
            newFolder = (Folder)this.renameObject((JCRAmetysObject)folder, name, errors);
            if (!errors.isEmpty()) {
                result.put("success", false);
                result.put("message", errors.get(0));
            } else {
                newFolder.saveChanges();
                result.put("success", true);
                result.putAll(this._extractFolderData((ResourceCollection)newFolder));
            }
        }
        catch (RepositoryException e) {
            this.getLogger().error("Repository exception during folder edition.", (Throwable)e);
            errors.add("repository");
        }
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> editFolder(String id, String inputName, String description) {
        Folder folder = (Folder)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_Folder_Edit", (Object)folder) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to edit folder without convenient right [Plugin_Explorer_Folder_Edit]");
        }
        LinkedList<String> errors = new LinkedList<String>();
        Folder newFolder = null;
        boolean success = true;
        try {
            newFolder = StringUtils.isBlank((CharSequence)inputName) || folder.getName().equals(inputName) ? folder : (Folder)this.renameObject((JCRAmetysObject)folder, inputName, errors);
        }
        catch (RepositoryException e) {
            success = false;
            this.getLogger().error("Repository exception during folder edition.", (Throwable)e);
            errors.add("repository");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            if (!"already-exist".equals(error)) {
                success = false;
                result.put("message", error);
            } else {
                newFolder = folder;
            }
        }
        if (success && newFolder != null) {
            if (!Strings.CS.equals(newFolder.getDescription(), description)) {
                newFolder.setDescription(description);
            }
            newFolder.saveChanges();
            result.putAll(this._extractFolderData((ResourceCollection)newFolder));
        }
        result.put("success", success);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> deleteFolder(String id) {
        ResourceCollection rootCollection;
        boolean isRoot;
        RemovableAmetysObject folder = (RemovableAmetysObject)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_Folder_Delete", (Object)folder) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to delete folder without convenient right [Plugin_Explorer_Folder_Delete]");
        }
        LinkedList errors = new LinkedList();
        String parentId = this.deleteObject(folder, errors);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            result.put("message", error);
        }
        boolean bl = isRoot = (rootCollection = this._getRootFromRequest()) != null && rootCollection.getId().equals(parentId);
        if (StringUtils.isNotEmpty((CharSequence)parentId) && !isRoot) {
            result.put("parentId", parentId);
        }
        return result;
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public boolean resourceExists(String parentId, String name) {
        ResourceCollection folder = this._getRootIfNull(parentId);
        return folder != null && this.resourceExists((TraversableAmetysObject)folder, name);
    }

    @Callable(rights={""})
    public Map<String, Object> renameFile(String id, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        File file = (File)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_File_Rename", (Object)file) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to rename file without convenient right [Plugin_Explorer_File_Rename]");
        }
        if (StringUtils.isNotEmpty((CharSequence)name) && !StringUtils.equals((CharSequence)file.getName(), (CharSequence)name)) {
            LinkedList<String> errors = new LinkedList<String>();
            File renamedFile = null;
            try {
                renamedFile = (File)this.renameResource(file, name, errors);
                if (!errors.isEmpty()) {
                    result.put("success", false);
                    result.put("message", errors.get(0));
                } else {
                    renamedFile.saveChanges();
                    result.put("success", true);
                    result.putAll(this._extractFileData((Resource)renamedFile));
                }
            }
            catch (RepositoryException e) {
                this.getLogger().error("Repository exception during file edition.", (Throwable)e);
                errors.add("repository");
            }
        }
        return result;
    }

    public Map<String, Object> editFile(String id, String inputName, String description, Collection<String> tags) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        File file = (File)this._resolver.resolveById(id);
        if (!this.checkLock((AmetysObject)file)) {
            this.getLogger().warn("User '{}' is trying to edit file '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)file.getName());
            result.put("message", "locked");
            return result;
        }
        LinkedList<String> errors = new LinkedList<String>();
        File renamedFile = null;
        if (StringUtils.isNotEmpty((CharSequence)inputName) && !StringUtils.equals((CharSequence)file.getName(), (CharSequence)inputName)) {
            if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_File_Rename", (Object)file) != RightManager.RightResult.RIGHT_ALLOW) {
                throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to rename file without convenient right [Plugin_Explorer_File_Rename]");
            }
            try {
                renamedFile = (File)this.renameResource(file, inputName, errors);
                if (errors.isEmpty()) {
                    file = renamedFile;
                }
            }
            catch (RepositoryException e) {
                this.getLogger().error("Repository exception during folder edition.", (Throwable)e);
                errors.add("repository-rename");
            }
        }
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            result.put("message", error);
            return result;
        }
        List<String> fileTags = this._sanitizeFileTags(tags);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_File_Edit_DC_Metadata", (Object)file) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to edit dc for file without convenient right [Plugin_Explorer_File_Edit_DC_Metadata]");
        }
        HashMap<String, CharSequence> editValues = new HashMap<String, CharSequence>();
        editValues.put("dc_description", StringUtils.defaultIfEmpty((CharSequence)description, null));
        try {
            file.setKeywords(fileTags.toArray(new String[fileTags.size()]));
            if (!StringUtils.equals((CharSequence)file.getDescription(), (CharSequence)description)) {
                file.setDescription(description);
                file.setIsAutoGeneratedDescription(false);
            }
            this.setDCMetadata((ModifiableResource)file, editValues);
            this._projectManager.addTags(fileTags);
            file.saveChanges();
        }
        catch (AmetysRepositoryException e) {
            this.getLogger().error("Repository exception during file edition", (Throwable)e);
            errors.add("repository-edit");
        }
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            result.put("message", error);
        } else {
            result.putAll(this._extractFileData((Resource)file));
        }
        return result;
    }

    @Callable(rights={"Plugin_Explorer_File_Edit_DC_Metadata"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public Map<String, Object> setTags(String resourceId, List<Object> tags) {
        File file = (File)this._resolver.resolveById(resourceId);
        Project project = this.getProjectFromRequest();
        ResourceCollection documentRoot = this.getRootFromProject(project);
        List<Map<String, Object>> createdTagsJson = this._workspaceHelper.handleTags((TaggableAmetysObject)file, tags, (TraversableAmetysObject)documentRoot);
        file.saveChanges();
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("fileTags", this._tags2json((Resource)file));
        results.put("newTags", createdTagsJson);
        return results;
    }

    @Callable(rights={"Plugin_Explorer_File_Edit_DC_Metadata"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public Map<String, Object> setDescription(String resourceId, String description) {
        return this.editFile(resourceId, null, description, null);
    }

    @Callable(rights={""})
    public Map<String, Object> copyFoldersAndFiles(List<String> ids, String targetId) throws RepositoryException {
        ResourceCollection folder = this._getRootIfNull(targetId);
        if (folder == null) {
            throw new IllegalArgumentException("Unable to copy files: parent folder not found");
        }
        if (!(folder instanceof ModifiableResourceCollection)) {
            throw new IllegalArgumentException("Cannot copy files on a non-modifiable folder '" + targetId + "'");
        }
        Map results = this.copyObject(ids, (JCRTraversableAmetysObject)folder);
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> moveDocuments(List<String> ids, String targetId) throws RepositoryException {
        ResourceCollection folder = this._getRootIfNull(targetId);
        if (folder == null) {
            throw new IllegalArgumentException("Unable to move documents: parent folder not found");
        }
        if (!(folder instanceof JCRTraversableAmetysObject)) {
            throw new IllegalArgumentException("Cannot move files on a non-modifiable folder '" + targetId + "'");
        }
        return this.moveObject(ids, (JCRTraversableAmetysObject)folder);
    }

    @Callable(rights={""})
    public Map<String, Object> searchFiles(String query, String lang) throws Exception {
        MatchAllQuery solrQuery;
        if (!this._projectRightsHelper.hasReadAccessOnModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to do read operation without convenient right");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String escapedQuery = query.replace("\"", "\\\"");
        if (StringUtils.isEmpty((CharSequence)query)) {
            solrQuery = new MatchAllQuery();
        } else {
            ArrayList<Object> queries = new ArrayList<Object>();
            queries.add(new FilenameQuery(query));
            queries.add(new StringQuery("title", Query.Operator.LIKE, "*" + query + "*", null));
            queries.add(new FullTextQuery(escapedQuery, lang));
            queries.add(new KeywordQuery(escapedQuery.split(" ")));
            solrQuery = new OrQuery(queries);
        }
        AmetysObjectIterable results = this._searcherFactory.create().withQuery((Query)solrQuery).addFilterQuery((Query)new DocumentTypeQuery("projectResource")).addFilterQuery((Query)new ProjectQuery(this.getProjectFromRequest().getId())).search();
        List resourceData = results.stream().map(this::_extractFileData).collect(Collectors.toList());
        result.put("resources", resourceData);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> searchFilesByType(String type) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        AmetysObjectIterable results = this._searcherFactory.create().withQuery((Query)new MimeTypeGroupQuery(type)).addFilterQuery((Query)new DocumentTypeQuery("projectResource")).addFilterQuery((Query)new ProjectQuery(this.getProjectFromRequest().getId())).search();
        List resourceData = results.stream().map(this::_extractFileData).collect(Collectors.toList());
        result.put("resources", resourceData);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> getRootFolder() {
        return this.getFolder(null);
    }

    @Callable(rights={""})
    public Map<String, Object> getRootNodeInfo(String projectName) {
        Project project = this._projectManager.getProject(projectName);
        if (!this._projectRightsHelper.hasReadAccessOnModule(project, DocumentWorkspaceModule.DOCUMENT_MODULE_ID)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to do read operation without convenient right");
        }
        ResourceCollection projectRoot = this.getRootFromProject(project);
        return projectRoot != null ? this.getDefaultInfoAsRootNode((ExplorerNode)projectRoot, project.getTitle()) : Map.of();
    }

    public Map<String, Object> getDefaultInfoAsRootNode(ExplorerNode rootNode, String projectTitle) {
        Map result = this.getDefaultInfoAsRootNode(rootNode);
        result.put("title", projectTitle);
        result.put("path", "/dummy/documents");
        result.put("name", "documents");
        return result;
    }

    @Callable(rights={"*"})
    public Map<String, Object> getResourceProject(String resourceId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            AmetysObject resource = this._resolver.resolveById(resourceId);
            Project project = this._getProjectFomObject(resource);
            result.put("project", project != null ? project.getName() : null);
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().error("Resource '{}' could not be found, it might have been deleted", (Object)resourceId);
            result.put("resourceNotFound", resourceId);
            result.put("project", null);
        }
        return result;
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public List<String> filterResourcesByRegExp(String id, String value, List<String> allowedExtensions) {
        List matchingPathsWithRoot = super.filterResourcesByRegExp(id, value, allowedExtensions);
        ArrayList<String> strippedMatchingPaths = new ArrayList<String>();
        for (String path : matchingPathsWithRoot) {
            strippedMatchingPaths.add(path.substring("/documents".length()));
        }
        return strippedMatchingPaths;
    }

    @Callable(rights={""})
    public Map<String, Object> getFolder(String folderId) {
        ResourceCollection collection = this._getRootIfNull(folderId);
        if (this._rightManager.currentUserHasReadAccess((Object)collection)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to do read operation without convenient right");
        }
        return this._extractFolderData(collection);
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public Map<String, Object> getFile(String resourceId) {
        Resource resource = (Resource)this._resolver.resolveById(resourceId);
        return this._extractFileData(resource);
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public List<Map<String, Object>> getFolders(String parentId) {
        return this.getChildDocumentsData(parentId, false, true);
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public List<Map<String, Object>> getFiles(String parentId) {
        return this.getChildDocumentsData(parentId, true, false);
    }

    @Callable(rights={""})
    public Map<String, Object> getFileParentInfo(String fileId) {
        try {
            Resource file = (Resource)this._resolver.resolveById(fileId);
            AmetysObject parent = file.getParent();
            String parentId = parent != null && parent instanceof ResourceCollection ? parent.getId() : null;
            return this.getFoldersAndFiles(parentId);
        }
        catch (AmetysRepositoryException e) {
            return Map.of("error", "invalid-item-id");
        }
    }

    @Callable(rights={""})
    public Map<String, Object> getFoldersAndFiles(String folderId) {
        ResourceCollection collection;
        ResourceCollection root = this._getRootFromRequest();
        ResourceCollection resourceCollection = collection = StringUtils.isNotEmpty((CharSequence)folderId) ? (ResourceCollection)this._resolver.resolveById(folderId) : root;
        if (!this._rightManager.currentUserHasReadAccess((Object)collection)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' try to access folder resources without rights");
        }
        Map<String, Object> data = this._extractFolderData(collection);
        data.put("root", collection.getId().equals(root.getId()));
        data.put("files", this.getChildDocumentsData(folderId, true, false));
        List<Map<String, Object>> children = this.getChildDocumentsData(folderId, false, true);
        data.put("children", children);
        return data;
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public List<Map<String, Object>> getChildDocumentsData(String parentId, boolean excludeFolders, boolean excludeFiles) {
        ResourceCollection document = this._getRootIfNull(parentId);
        if (document == null) {
            throw new IllegalArgumentException("Unable to get child documents: parent folder not found");
        }
        return this.getChildDocumentsData(document, excludeFolders, excludeFiles);
    }

    public List<Map<String, Object>> getChildDocumentsData(ResourceCollection document, boolean excludeFolders, boolean excludeFiles) {
        ResourceCollection parent = this._getRootIfNull(document);
        if (parent == null) {
            throw new IllegalArgumentException("Unable to get child documents: parent folder not found");
        }
        return parent.getChildren().stream().map(child -> this._extractDocumentData((AmetysObject)child, excludeFolders, excludeFiles)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Callable(rights={"*"})
    public String generateWebdavUri(String documentId) {
        return ResolveURIComponent.resolve((String)"webdav-project-resource", (String)documentId, (boolean)false, (boolean)true);
    }

    private ResourceCollection _getRootIfNull(ResourceCollection document) {
        return document != null ? document : this._getRootFromRequest();
    }

    private ResourceCollection _getRootIfNull(String documentId) {
        return StringUtils.isNotEmpty((CharSequence)documentId) ? (ResourceCollection)this._resolver.resolveById(documentId) : this._getRootFromRequest();
    }

    private ResourceCollection _getRootFromRequest() {
        Project project = this.getProjectFromRequest();
        if (project != null) {
            return this.getRootFromProject(project);
        }
        return null;
    }

    private ResourceCollection _getRootFromObject(AmetysObject ametysObject) {
        Project project = this._getProjectFomObject(ametysObject);
        if (project != null) {
            return this.getRootFromProject(project);
        }
        return null;
    }

    public ResourceCollection getRootFromProject(Project project) {
        if (project != null) {
            DocumentWorkspaceModule module = (DocumentWorkspaceModule)this._moduleEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
            return module.getModuleRoot(project, false);
        }
        return null;
    }

    public Project getProjectFromRequest() {
        Request request = ContextHelper.getRequest((Context)this._context);
        String projectName = (String)request.getAttribute("projectName");
        if (projectName != null) {
            return this._projectManager.getProject(projectName);
        }
        return null;
    }

    private Project _getProjectFomObject(AmetysObject ametysObject) {
        AmetysObject parent;
        for (parent = ametysObject; parent != null && !(parent instanceof Project); parent = parent.getParent()) {
        }
        if (parent == null) {
            return null;
        }
        return (Project)parent;
    }

    private String _getCurrentLanguage() {
        Request request = ContextHelper.getRequest((Context)this._context);
        return (String)request.getAttribute("sitemapLanguage");
    }

    protected Map<String, Object> _extractDocumentData(AmetysObject document, boolean excludeFolders, boolean excludeFiles) {
        ResourceCollection folder;
        if (!excludeFiles && document instanceof Resource) {
            Resource file = (Resource)document;
            if (this._canView(file)) {
                return this._extractFileData(file);
            }
        } else if (!excludeFolders && document instanceof ResourceCollection && this._canView(folder = (ResourceCollection)document)) {
            return this._extractFolderData(folder);
        }
        return null;
    }

    protected Map<String, Object> _extractFolderData(ResourceCollection folder) {
        boolean hasChildren;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", folder.getId());
        data.put("name", folder.getName());
        data.put("path", this._getFolderPath(folder));
        data.put("type", ResourceType.FOLDER.name().toLowerCase());
        data.put("description", StringUtils.defaultString((String)folder.getDescription()));
        AmetysObject parent = folder.getParent();
        if (parent != null && parent instanceof ResourceCollection) {
            data.put("location", parent.getName());
            data.put("parentId", parent.getId());
        }
        if (hasChildren = this._hasChildren(folder, true)) {
            data.put("children", Collections.EMPTY_LIST);
            data.put("hasChildren", true);
        }
        data.put("modifiable", folder instanceof ModifiableAmetysObject);
        data.put("canCreateChild", folder instanceof ModifiableExplorerNode);
        data.put("rights", this._extractFolderRightData(folder));
        data.put("notification", false);
        return data;
    }

    private List<String> _getFolderPath(ResourceCollection folder) {
        ArrayList<String> paths = new ArrayList<String>();
        ResourceCollection rootDocuments = this._getRootFromObject((AmetysObject)folder);
        if (!rootDocuments.equals((Object)folder)) {
            ArrayList<Object> parents = new ArrayList<Object>();
            AmetysObject parent = folder.getParent();
            while (parent instanceof ExplorerNode && !parent.equals((Object)rootDocuments)) {
                parents.add((ExplorerNode)parent);
                parent = parent.getParent();
            }
            parents.add(rootDocuments);
            Collections.reverse(parents);
            parents.stream().forEach(p -> paths.add(p.getId()));
        }
        return paths;
    }

    protected boolean _hasChildren(ResourceCollection folder, boolean ignoreFiles) {
        try (AmetysObjectIterable children = folder.getChildren();){
            for (AmetysObject child : children) {
                if ((!(child instanceof ResourceCollection) || !this._canView((ResourceCollection)child)) && (ignoreFiles || !(child instanceof Resource) || !this._canView((Resource)child))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected Map<String, Object> _extractFolderRightData(ResourceCollection folder) {
        HashMap<String, Object> rightsData = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        rightsData.put("add-file", this._rightManager.hasRight(user, "Plugin_Explorer_File_Add", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("add-folder", this._rightManager.hasRight(user, "Plugin_Explorer_Folder_Add", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("add-cmis-folder", this._rightManager.hasRight(user, "Plugin_Explorer_CMIS_Add", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("edit", this._rightManager.hasRight(user, "Plugin_Explorer_Folder_Edit", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("delete", this._rightManager.hasRight(user, "Plugin_Explorer_Folder_Delete", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        return rightsData;
    }

    @Callable(rights={""})
    public Map<String, Object> addFile(Part part, String parentId, boolean unarchive, boolean allowRename, boolean allowUpdate) {
        ModifiableResourceCollection modifiableFolder = this._getModifiableResourceCollection(parentId);
        this._addOrUpdateResourceHelper.checkAddResourceRight(modifiableFolder);
        AddOrUpdateResourceHelper.ResourceOperationMode mode = this.getOperationMode(unarchive, allowRename, allowUpdate);
        AddOrUpdateResourceHelper.ResourceOperationResult operationResult = this._addOrUpdateResourceHelper.performResourceOperation(part, modifiableFolder, mode);
        return this.generateActionResult((ResourceCollection)modifiableFolder, operationResult);
    }

    public Map<String, Object> addFile(InputStream inputStream, String fileName, String parentId, boolean unarchive, boolean allowRename, boolean allowUpdate) {
        ModifiableResourceCollection modifiableFolder = this._getModifiableResourceCollection(parentId);
        AddOrUpdateResourceHelper.ResourceOperationMode mode = this.getOperationMode(unarchive, allowRename, allowUpdate);
        AddOrUpdateResourceHelper.ResourceOperationResult operationResult = this._addOrUpdateResourceHelper.performResourceOperation(inputStream, fileName, modifiableFolder, mode);
        return this.generateActionResult((ResourceCollection)modifiableFolder, operationResult);
    }

    private ModifiableResourceCollection _getModifiableResourceCollection(String folderId) {
        ResourceCollection folder = this._getRootIfNull(folderId);
        if (folder == null) {
            throw new IllegalArgumentException("Root folder not found");
        }
        if (!(folder instanceof ModifiableResourceCollection)) {
            throw new IllegalArgumentException("Folder '" + folderId + "' not modifiable");
        }
        return (ModifiableResourceCollection)folder;
    }

    private AddOrUpdateResourceHelper.ResourceOperationMode getOperationMode(boolean unarchive, boolean allowRename, boolean allowUpdate) {
        AddOrUpdateResourceHelper.ResourceOperationMode mode = AddOrUpdateResourceHelper.ResourceOperationMode.ADD;
        if (unarchive) {
            mode = AddOrUpdateResourceHelper.ResourceOperationMode.ADD_UNZIP;
        } else if (allowRename) {
            mode = AddOrUpdateResourceHelper.ResourceOperationMode.ADD_RENAME;
        } else if (allowUpdate) {
            mode = AddOrUpdateResourceHelper.ResourceOperationMode.UPDATE;
        }
        return mode;
    }

    private Map<String, Object> generateActionResult(ResourceCollection folder, AddOrUpdateResourceHelper.ResourceOperationResult operationResult) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (operationResult.isSuccess()) {
            List resourceData = operationResult.getResources().stream().filter(r -> r.getParent().equals((Object)folder)).map(this::_extractFileData).collect(Collectors.toList());
            result.put("resources", resourceData);
            result.put("unzip", operationResult.isUnzip());
        } else {
            result.put("message", operationResult.getErrorMessage());
        }
        return result;
    }

    protected Map<String, Object> _extractFileData(Resource file) {
        String resourcePath;
        int i;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", file.getId());
        data.put("name", file.getName());
        data.put("path", this._getFilePath(file));
        if (file instanceof File) {
            File f = (File)file;
            data.put("description", f.getDescription());
            data.put("isAIDescription", f.isAutomaticallyGeneratedDescription());
            data.put("token", f.getToken());
        }
        resourcePath = (i = (resourcePath = file.getResourcePath()).lastIndexOf(".")) != -1 ? resourcePath.substring(0, i) : resourcePath;
        String encodedPath = FilenameUtils.encodePath((String)resourcePath);
        data.put("encodedPath", URIUtils.encodeURI((String)encodedPath, Map.of()));
        data.put("type", ResourceType.FILE.name().toLowerCase());
        data.put("fileType", this._workspaceHelper.getFileType(file).name().toLowerCase());
        data.put("fileExtension", StringUtils.substringAfterLast((String)file.getName(), (String)"."));
        AmetysObject parent = file.getParent();
        if (parent != null && parent instanceof ResourceCollection) {
            data.put("location", parent.getName());
            data.put("parentId", parent.getId());
            data.put("parentPath", ((ResourceCollection)parent).getExplorerPath());
        }
        data.put("modifiable", file instanceof ModifiableResource);
        data.put("canCreateChild", file instanceof ModifiableExplorerNode);
        data.put("tags", this._tags2json(file));
        data.put("tagsBis", this._tags2json(file));
        data.put("mimetype", file.getMimeType());
        data.put("length", String.valueOf(file.getLength()));
        boolean image = this._workspaceHelper.isImage(file);
        if (image) {
            data.put("image", true);
        }
        data.put("hasOnlyOfficePreview", this._onlyOfficeManager.canBePreviewed(file.getId()));
        UserIdentity creatorIdentity = file.getCreator();
        data.put("creator", this._userHelper.user2json(creatorIdentity));
        data.put("creationDate", DateUtils.dateToString((Date)file.getCreationDate()));
        UserIdentity contribIdentity = file.getLastContributor();
        data.put("author", this._userHelper.user2json(contribIdentity));
        data.put("lastModified", DateUtils.dateToString((Date)file.getLastModified()));
        data.put("rights", this._extractFileRightData(file));
        data.putAll(this._extractFileLockData(file));
        return data;
    }

    private List<Map<String, Object>> _tags2json(Resource file) {
        return ((TagAwareAmetysObject)file).getTags().stream().filter(tag -> this._tagProviderExtensionPoint.hasTag((String)tag, Map.of())).map(tag -> (DefaultTag)this._tagProviderExtensionPoint.getTag((String)tag, Map.of())).map(this::_tag2json).collect(Collectors.toList());
    }

    private Map<String, Object> _tag2json(Tag tag) {
        HashMap<String, Object> tagMap = new HashMap<String, Object>();
        tagMap.put("text", tag.getTitle());
        tagMap.put("title", tag.getTitle());
        tagMap.put("name", tag.getName());
        tagMap.put("color", null);
        return tagMap;
    }

    private List<String> _getFilePath(Resource file) {
        return this._getFolderPath((ResourceCollection)file.getParent());
    }

    protected Map<String, Object> _extractFileRightData(Resource file) {
        ResourceCollection folder;
        HashMap<String, Object> rightsData = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        rightsData.put("rename", this._rightManager.hasRight(user, "Plugin_Explorer_File_Rename", (Object)(folder = (ResourceCollection)file.getParent())) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("edit", this._rightManager.hasRight(user, "Plugin_Explorer_File_Edit_DC_Metadata", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("delete", this._rightManager.hasRight(user, "Plugin_Explorer_File_Delete", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("unlock", this._rightManager.hasRight(user, "Plugin_Explorer_File_Unlock_All", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("comment", this._rightManager.hasRight(user, RIGHTS_RESOURCE_COMMENT, (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("moderate-comments", this._rightManager.hasRight(user, "Plugin_Explorer_File_Moderate_Comments", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("summarize", this._aiHelper != null && this._aiHelper.isEnabled() && this._rightManager.hasRight(user, "AI_Rights_Use", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        return rightsData;
    }

    protected Map<String, Object> _extractFileLockData(Resource file) {
        HashMap<String, Object> lockData = new HashMap<String, Object>();
        if (file instanceof LockableAmetysObject) {
            boolean isLocked = ((LockableAmetysObject)file).isLocked();
            lockData.put("locked", isLocked);
            if (isLocked) {
                UserIdentity lockOwner = ((LockableAmetysObject)file).getLockOwner();
                lockData.put("isLockOwner", lockOwner.equals((Object)this._currentUserProvider.getUser()));
                lockData.put("lockOwner", this._userHelper.user2json(lockOwner));
            }
        }
        return lockData;
    }

    private List<String> _sanitizeFileTags(Collection<String> tags) throws AmetysRepositoryException {
        return Optional.ofNullable(tags).orElseGet(ArrayList::new).stream().map(String::trim).map(String::toLowerCase).distinct().collect(Collectors.toList());
    }

    protected boolean _canView(ResourceCollection folder) {
        return this._rightManager.currentUserHasReadAccess((Object)folder);
    }

    protected boolean _canView(Resource file) {
        return this._rightManager.currentUserHasReadAccess((Object)file.getParent());
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public Map<String, String> getCMISProperties(String id) {
        return super.getCMISProperties(id);
    }

    @Callable(rights={""})
    public Map<String, Object> addCMISCollection(String parentId, String originalName, String url, String login, String password, String repoId, String mountPoint, boolean renameIfExists) {
        String rootId;
        String string = rootId = parentId == null ? this._getRootFromRequest().getId() : parentId;
        if (rootId == null) {
            throw new IllegalArgumentException("Unable to add CMIS collection: parent folder not found.");
        }
        return super.addCMISCollection(rootId, originalName, url, login, password, repoId, mountPoint, renameIfExists);
    }

    @Callable(rights={""})
    public Map<String, Object> editCMISCollection(String id, String name, String url, String login, String password, String repoId, String mountPoint) throws RepositoryException {
        LinkedList<String> errors = new LinkedList<String>();
        try {
            this.renameObject(id, name);
        }
        catch (RepositoryException e) {
            this.getLogger().error("Repository exception during CMIS folder edition.", (Throwable)e);
            errors.add("repository");
        }
        Map result = super.editCMISCollection(id, url, login, password, repoId, mountPoint);
        if (errors.size() > 0) {
            result.put("errors", errors);
        }
        return result;
    }

    @Callable(rights={"__READ_ACCESS", "Plugin_Explorer_CMIS_Add"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public boolean isCMISCollection(String id) {
        return super.isCMISCollection(id);
    }

    public Long getDocumentsCount(Project project) {
        Function<Project, ResourceCollection> getModuleRoot = proj -> this._moduleEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID).getModuleRoot((Project)((Object)proj), false);
        return Optional.ofNullable(project).map(getModuleRoot).map(root -> this._getChildDocumentsCount((ResourceCollection)root)).orElse(null);
    }

    private Long _getChildDocumentsCount(ResourceCollection collection) {
        return collection.getChildren().stream().map(ao -> ao instanceof Resource ? 1L : (ao instanceof ResourceCollection ? this._getChildDocumentsCount((ResourceCollection)ao) : 0L)).reduce(0L, Long::sum);
    }

    private String _toFullLanguage(String language) {
        switch (language) {
            case "en": {
                return "en-US";
            }
            case "zh": {
                return "zh-CN";
            }
        }
        return language + "-" + language.toUpperCase();
    }

    @Callable(rights={""})
    public Map<String, Object> createFile(String folderId, String type, String language) throws Exception {
        ModifiableResourceCollection modifiableFolder = this._getModifiableResourceCollection(folderId);
        this._addOrUpdateResourceHelper.checkAddResourceRight(modifiableFolder);
        String fullLanguage = this._toFullLanguage(language);
        OfficeType officeType = OfficeType.valueOf(type.toUpperCase());
        String lang = this._getCurrentLanguage();
        SpreadsheetMLPackage opcPackage = null;
        String name = null;
        String title = null;
        switch (officeType.ordinal()) {
            case 1: {
                opcPackage = SpreadsheetMLPackage.createPackage();
                opcPackage.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_FILE_MANAGER_ONLYOFFICE_EXCEL_NEW_FILE_PART1_TITLE"), lang), 1L);
                name = "newExcel.xlsx";
                title = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_FILE_MANAGER_ONLYOFFICE_EXCEL_NEW_FILE_TITLE"), lang) + ".xlsx";
                break;
            }
            case 0: {
                opcPackage = WordprocessingMLPackage.createPackage();
                ((Styles)((WordprocessingMLPackage)opcPackage).getMainDocumentPart().getStyleDefinitionsPart().getContents()).getDocDefaults().getRPrDefault().getRPr().getLang().setVal(fullLanguage);
                name = "newWord.docx";
                title = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_FILE_MANAGER_ONLYOFFICE_WORD_NEW_FILE_TITLE"), lang) + ".docx";
                break;
            }
            case 2: {
                opcPackage = PresentationMLPackage.createPackage();
                ObjectFactory objectFactory = new ObjectFactory();
                CTTextListStyle ctTextListStyle = objectFactory.createCTTextListStyle();
                CTTextParagraphProperties ctTextParagraphProperties = objectFactory.createCTTextParagraphProperties();
                CTTextCharacterProperties ctTextCharacterProperties = objectFactory.createCTTextCharacterProperties();
                ctTextCharacterProperties.setLang(fullLanguage);
                ctTextParagraphProperties.setDefRPr(ctTextCharacterProperties);
                ctTextListStyle.setDefPPr(ctTextParagraphProperties);
                ((Presentation)((PresentationMLPackage)opcPackage).getMainPresentationPart().getContents()).setDefaultTextStyle(ctTextListStyle);
                name = "newPowerPoint.pptx";
                title = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_FILE_MANAGER_ONLYOFFICE_POWERPOINT_NEW_FILE_TITLE"), lang) + ".pptx";
                break;
            }
            default: {
                throw new IllegalArgumentException("Can create new file with unknown type '" + type + "'");
            }
        }
        java.io.File file = new java.io.File(AmetysHomeHelper.getAmetysHomeTmp(), name);
        opcPackage.save(file);
        try (FileInputStream is = new FileInputStream(file);){
            String uniqueTitle = this._getUniqueTitle(folderId, title);
            Map<String, Object> response = this.addFile(is, uniqueTitle, folderId, false, false, false);
            FileUtils.forceDelete((java.io.File)file);
            Map<String, Object> map = response;
            return map;
        }
    }

    private String _getUniqueTitle(String folderId, String title) throws RepositoryException {
        JCRAmetysObject folder = (JCRAmetysObject)this._resolver.resolveById(folderId);
        String ext = StringUtils.substringAfterLast((String)title, (String)".");
        String name = StringUtils.substringBeforeLast((String)title, (String)".");
        Object newTitle = title;
        int count = 1;
        Node node = folder.getNode();
        while (node.hasNode((String)newTitle)) {
            newTitle = name + " (" + count + ")." + ext;
            ++count;
        }
        return newTitle;
    }

    public String getResourceCollectionType() {
        return "ametys:folder";
    }

    @Callable(rights={""})
    public Map<String, Object> getUserProjects2JSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        ArrayList projects = new ArrayList();
        Map<Project, JCRProjectMember.MemberType> userProjects = this._projectManager.getUserProjects(user);
        projects.addAll(userProjects.keySet().stream().filter(p -> this._projectRightsHelper.hasReadAccessOnModule((Project)((Object)p), DocumentWorkspaceModule.DOCUMENT_MODULE_ID)).map(p -> this._projectManager.getProjectProperties((Project)((Object)p))).collect(Collectors.toList()));
        result.put("projects", projects);
        return result;
    }

    @Callable(rights={"AI_Rights_Use"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public Map<String, Object> generateFileDescription(String fileId) {
        if (this._workspaceFileAIHelper == null) {
            throw new UnsupportedOperationException("Can't call method generateFileDescription without AI plugin");
        }
        File file = (File)this._resolver.resolveById(fileId);
        WorkspacesHelper.FileType fileType = this._workspaceHelper.getFileType((Resource)file);
        if (fileType == WorkspacesHelper.FileType.TEXT || fileType == WorkspacesHelper.FileType.PDF) {
            try {
                this._workspaceFileAIHelper.generateFileDescription(file);
                return this._extractFileData((Resource)file);
            }
            catch (Exception e) {
                this.getLogger().error("An error has occurred while generating the file description", (Throwable)e);
            }
        }
        return Map.of("error", "error");
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public Map<String, Object> createPublicLinkTokenForFile(String fileId) {
        File file = (File)this._resolver.resolveById(fileId);
        file.createToken();
        file.saveChanges();
        return this._extractFileData((Resource)file);
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public Map<String, Object> deleteTokenByFileId(String fileId) {
        File file = (File)this._resolver.resolveById(fileId);
        file.setTokens(List.of());
        file.saveChanges();
        return this._extractFileData((Resource)file);
    }

    public static enum ResourceType {
        FOLDER,
        FILE;

    }

    public static enum OfficeType {
        WORD,
        EXCEL,
        POWERPOINT;

    }
}

