/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents;

import java.util.Date;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.ai.AIHelper;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.workspaces.documents.jcr.File;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class WorkspaceFileAIHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = WorkspaceFileAIHelper.class.getName();
    public static final Integer SUMMARY_MAX_LENGTH = 200;
    private static final String __CONFIG_IS_AUTOMATIC_GENERATION_ENABLED = "workspaces.ai.docsummary.automatic.enabled";
    private AIHelper _aiHelper;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._aiHelper = (AIHelper)manager.lookup(AIHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public boolean isAutomaticGenerationEnabled() {
        return this._aiHelper.isEnabled() && (Boolean)Config.getInstance().getValue(__CONFIG_IS_AUTOMATIC_GENERATION_ENABLED, false, (Object)false) != false;
    }

    public String generateFileDescription(File file) throws Exception {
        String summary = this._aiHelper.resourceToSummary((Resource)file, SUMMARY_MAX_LENGTH.intValue());
        file.setDescription(summary);
        file.setIsAutoGeneratedDescription(true);
        file.setLastContributor(this._currentUserProvider.getUser());
        file.setLastModified(new Date());
        ModifiableResourceCollection parent = (ModifiableResourceCollection)file.getParent();
        parent.saveChanges();
        file.checkpoint();
        return summary;
    }
}

