/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.actions;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class DocumentArchiveUriAction
extends ServiceableAction {
    private WorkspaceModuleExtensionPoint _moduleEP;
    private ProjectManager _projectManager;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)smanager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String projectName = request.getParameter("projectName");
        Project project = this._projectManager.getProject(projectName);
        DocumentWorkspaceModule module = (DocumentWorkspaceModule)this._moduleEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
        ModifiableResourceCollection moduleRoot = module.getModuleRoot(project, false);
        String uri = "cocoon://_plugins/explorer/folder/archive.zip";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", moduleRoot.getId());
        params.put("name", project.getTitle() + " - " + this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_DOCUMENT_TREE_FOLDERS_TITLE")));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("uri", URIUtils.encodeURI((String)uri, params));
        return result;
    }
}

