/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.jcr;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.CommentableAmetysObject;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.explorer.resources.jcr.JCRResourceFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.workspaces.documents.jcr.FileFactory;

public class File
extends JCRResource<FileFactory>
implements CommentableAmetysObject<Comment> {
    public static final String TOKENS_NODE = "ametys:tokens";
    public static final String TOKEN_NODE = "ametys:token";
    public static final String TOKEN_ID = "tokenId";
    public static final String TOKEN_ID_PROPERTY = "ametys:tokenId";
    public static final String TOKEN_CREATION_DATE_PROPERTY = "ametys:creationDate";
    public static final String TOKEN_FILE_ID_PROPERTY = "ametys:fileId";

    public File(Node node, String parentPath, FileFactory factory) {
        super(node, parentPath, (JCRResourceFactory)factory);
    }

    public String getDescription() {
        try {
            Node fileNode = this.getNode();
            return fileNode.hasProperty("ametys:description") ? fileNode.getProperty("ametys:description").getString() : null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get description for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public void setDescription(String description) {
        try {
            Node fileNode = this.getNode();
            fileNode.setProperty("ametys:description", description);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set description for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public boolean isAutomaticallyGeneratedDescription() {
        try {
            Node fileNode = this.getNode();
            if (fileNode.hasProperty("ametys:isAutoGeneratedDescription")) {
                return fileNode.getProperty("ametys:isAutoGeneratedDescription").getBoolean();
            }
            return false;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get automatic description status for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public void setIsAutoGeneratedDescription(boolean isAutoGeneratedDescription) {
        try {
            Node fileNode = this.getNode();
            fileNode.setProperty("ametys:isAutoGeneratedDescription", isAutoGeneratedDescription);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set automatic description status for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public Comment createComment() {
        return new Comment(this._getCommentsDataHolder());
    }

    public Comment createComment(String commentId, ZonedDateTime creationDate) {
        return new Comment(this._getCommentsDataHolder(), commentId, creationDate);
    }

    public Comment getComment(String commentId) throws AmetysRepositoryException {
        return Comment.getComment((ModifiableModelLessDataHolder)this._getCommentsDataHolder(), (String)commentId);
    }

    public List<Comment> getComments(boolean includeNotValidatedComments, boolean includeValidatedComments) throws AmetysRepositoryException {
        return Comment.getComments((ModifiableModelLessDataHolder)this._getCommentsDataHolder(), (boolean)includeNotValidatedComments, (boolean)includeValidatedComments);
    }

    private ModifiableModelLessDataHolder _getCommentsDataHolder() {
        try {
            Node baseNode = this.getBaseNode();
            if (!baseNode.hasNode("ametys:comments")) {
                baseNode.addNode("ametys:comments", "ametys:compositeMetadata");
            }
            Node commentsNode = baseNode.getNode("ametys:comments");
            baseNode.getSession().save();
            JCRRepositoryData repositoryData = new JCRRepositoryData(commentsNode);
            return new DefaultModifiableModelLessDataHolder(((FileFactory)this._getFactory()).getUnversionedDataTypeExtensionPoint(), (ModifiableRepositoryData)repositoryData);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }

    public PublicLinkToken getToken() {
        ArrayList<PublicLinkToken> tokens = new ArrayList<PublicLinkToken>();
        try {
            Node fileNode = this.getNode();
            if (fileNode.hasNode(TOKENS_NODE)) {
                Node tokensNode = fileNode.getNode(TOKENS_NODE);
                NodeIterator tokenNodes = tokensNode.getNodes();
                while (tokenNodes.hasNext()) {
                    Node tokenNode = tokenNodes.nextNode();
                    String id = tokenNode.getProperty(TOKEN_ID_PROPERTY).getString();
                    ZonedDateTime creationDate = DateUtils.asZonedDateTime((Calendar)tokenNode.getProperty(TOKEN_CREATION_DATE_PROPERTY).getDate());
                    String fileId = tokenNode.getProperty(TOKEN_FILE_ID_PROPERTY).getString();
                    tokens.add(new PublicLinkToken(id, creationDate, fileId));
                }
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot get tokens for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
        if (tokens.isEmpty()) {
            return null;
        }
        PublicLinkToken token = (PublicLinkToken)tokens.get(0);
        if (!this.getId().equals(token.fileId())) {
            return null;
        }
        return token;
    }

    public void setTokens(List<PublicLinkToken> tokens) {
        try {
            Node tokensNode;
            Node fileNode = this.getNode();
            if (fileNode.hasNode(TOKENS_NODE)) {
                tokensNode = fileNode.getNode(TOKENS_NODE);
                tokensNode.remove();
            }
            tokensNode = fileNode.addNode(TOKENS_NODE, "ametys:compositeMetadata");
            for (PublicLinkToken token : tokens) {
                Node tokenNode = tokensNode.addNode(TOKEN_NODE, "ametys:compositeMetadata");
                tokenNode.setProperty(TOKEN_ID_PROPERTY, token.id());
                tokenNode.setProperty(TOKEN_CREATION_DATE_PROPERTY, DateUtils.asCalendar((ZonedDateTime)token.creationDate()));
                tokenNode.setProperty(TOKEN_FILE_ID_PROPERTY, token.fileId());
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Cannot set tokens for file " + this.getName() + " (" + this.getId() + ")", (Throwable)e);
        }
    }

    public PublicLinkToken createToken() {
        String tokenId = UUID.randomUUID().toString();
        ZonedDateTime creationDate = ZonedDateTime.now();
        PublicLinkToken newToken = new PublicLinkToken(tokenId, creationDate, this.getId());
        ArrayList<PublicLinkToken> tokens = new ArrayList<PublicLinkToken>();
        tokens.add(newToken);
        this.setTokens(tokens);
        return newToken;
    }

    public record PublicLinkToken(String id, ZonedDateTime creationDate, String fileId) {
    }
}

