/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.onlyoffice;

import java.io.File;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.workspaces.documents.onlyoffice.OnlyOfficeManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public class GetThumbnailAction
extends ServiceableAction
implements ThreadSafe {
    protected OnlyOfficeManager _onlyOfficeManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._onlyOfficeManager = (OnlyOfficeManager)((Object)smanager.lookup(OnlyOfficeManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String projectName = parameters.getParameter("projectName");
        String resourceId = parameters.getParameter("resourceId");
        try {
            Map<String, String> info = this._getThumbnailInfo(projectName, resourceId);
            if (info != null) {
                return info;
            }
            this._onlyOfficeManager.generateThumbnailInCache(projectName, resourceId, this._currentUserProvider.getUser());
            return this._getThumbnailInfo(projectName, resourceId);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred getting thumbnail for project '" + projectName + "' and resourceId '" + resourceId + "'", (Throwable)e);
            return null;
        }
    }

    private Map<String, String> _getThumbnailInfo(String projectName, String resourceId) {
        File thumbnailFile = this._onlyOfficeManager.getThumbnailFile(projectName, resourceId);
        if (thumbnailFile != null && thumbnailFile.exists()) {
            return Map.of("thumbnail-path", URIUtils.encodePath((String)thumbnailFile.getAbsolutePath()));
        }
        return null;
    }
}

