/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.keywords;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.tag.AbstractTagsDAO;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.keywords.KeywordJCRDAO;
import org.ametys.plugins.workspaces.keywords.KeywordJCRProvider;
import org.ametys.plugins.workspaces.keywords.KeywordProviderExtensionPoint;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class KeywordsDAO
extends AbstractTagsDAO {
    public static final String ROLE = KeywordsDAO.class.getName();
    protected AmetysObjectResolver _resolver;
    protected ProjectRightHelper _projectRightsHelper;
    protected CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;
    private KeywordJCRDAO _keywordJCRDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._keywordJCRDAO = (KeywordJCRDAO)((Object)manager.lookup(KeywordJCRDAO.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._projectRightsHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public String getTagProviderEPRole() {
        return KeywordProviderExtensionPoint.ROLE;
    }

    protected List<TagProvider<? extends Tag>> getCustomTagProvider() {
        ArrayList<TagProvider<? extends Tag>> providers = new ArrayList<TagProvider<? extends Tag>>();
        providers.add((TagProvider)this._tagProviderExtPt.getExtension(KeywordJCRProvider.class.getName()));
        return providers;
    }

    @Callable(rights={""})
    public Map<String, Object> getKeywords(String zoneItemId) {
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        if (!this._projectRightsHelper.hasCatalogReadAccess(zoneItem)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to access workspaces' keywords without convenient right");
        }
        ArrayList tags = new ArrayList();
        for (String id : this._tagProviderExtPt.getExtensionsIds()) {
            TagProvider tagProvider = (TagProvider)this._tagProviderExtPt.getExtension(id);
            Map someTags = tagProvider.getTags(Collections.emptyMap());
            tags.addAll(this._tagsToJSON(someTags.values()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("keywords", tags);
        SitemapElement catalogPage = zoneItem.getZone().getSitemapElement();
        result.put("canCreate", this._rightManager.currentUserHasRight("Workspace_Rights_Keywords_HandleKeyword", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW || this._rightManager.currentUserHasRight("Workspace_Rights_Keywords_HandleKeyword", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW);
        return result;
    }

    protected AbstractJCRTagsDAO _getTagJCRDAO() {
        return this._keywordJCRDAO;
    }
}

