/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;
import org.ametys.plugins.workspaces.project.favorites.FavoritesHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MemberProjectsGenerator
extends ServiceableGenerator {
    protected ProjectManager _projectManager;
    protected ProjectsCatalogueManager _projectCatalogManager;
    protected CurrentUserProvider _currentUserProvider;
    protected FavoritesHelper _favoritesHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._projectCatalogManager = (ProjectsCatalogueManager)((Object)smanager.lookup(ProjectsCatalogueManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._favoritesHelper = (FavoritesHelper)((Object)this.manager.lookup(FavoritesHelper.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"projects");
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        UserIdentity user = this._getUser(request);
        if (user != null) {
            Set<String> filteredCategories = this._getFilteredCategories(request);
            String pattern = request.getParameter("pattern");
            boolean excludePrivate = this.parameters.getParameterAsBoolean("excludePrivate", false);
            Map<Project, JCRProjectMember.MemberType> userProjects = this._projectManager.getUserProjects(user, filteredCategories, null, pattern, false, excludePrivate);
            Set<String> favorites = this._favoritesHelper.getFavorites(user);
            List projects = userProjects.keySet().stream().collect(Collectors.toList());
            int maxMembers = this.parameters.getParameterAsInteger("maxMembers", Integer.MAX_VALUE);
            boolean withMembers = this.parameters.getParameterAsBoolean("withMembers", false);
            boolean expandGroup = this.parameters.getParameterAsBoolean("expandGroup", false);
            for (Project project : projects) {
                this._projectCatalogManager.saxProject(this.contentHandler, project, withMembers, expandGroup, maxMembers, favorites.contains(project.getName()));
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"projects");
        this.contentHandler.endDocument();
    }

    private UserIdentity _getUser(Request request) {
        boolean userContent = this.parameters.getParameterAsBoolean("userContent", false);
        if (userContent) {
            Content content = (Content)request.getAttribute(Content.class.getName());
            return (UserIdentity)content.getValue("user");
        }
        return this._currentUserProvider.getUser();
    }

    private Set<String> _getFilteredCategories(Request request) {
        String[] categoryIds = request.getParameterValues("categories");
        if (categoryIds != null) {
            return Arrays.stream(categoryIds).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        }
        return Set.of();
    }
}

