/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.report;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.report.ReportHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ReportServiceGenerator
extends ServiceableGenerator {
    private ReportHelper _reportHelper;
    private CategoryHelper _categoryHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._reportHelper = (ReportHelper)smanager.lookup(ReportHelper.ROLE);
        this._categoryHelper = (CategoryHelper)smanager.lookup(CategoryHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"reports");
        List<Project> availableProjects = this._reportHelper.getAvailableProjects();
        Set<Category> rootCategories = this._reportHelper.getAvailableCategories(availableProjects);
        this.saxCategories(rootCategories);
        this.saxProjects(availableProjects);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"reports");
        this.contentHandler.endDocument();
    }

    protected void saxProjects(List<Project> projects) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"projects");
        for (Project project : projects) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", project.getId());
            attrs.addCDATAAttribute("name", project.getName());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"project", (Attributes)attrs, (String)project.getTitle());
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"projects");
    }

    protected void saxCategories(Set<Category> rootCategories) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"categories");
        for (Category category : rootCategories) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", category.getId());
            attrs.addCDATAAttribute("name", category.getName());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"category", (Attributes)attrs);
            Map<String, String> colors = this._categoryHelper.getCategoryColor(category);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"color", (String)colors.get("main"));
            category.getTitle().toSAX(this.contentHandler, "title");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"category");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"categories");
    }
}

