/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const DateUtils = Java.type("org.ametys.core.util.DateUtils");
const EventRecurrenceTypeEnum = Java.type("org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum");

logger.info(`Start migration of calendar activities...`);

migrateCalendarActivityNodes(Repository.session);
migrateCalendarActivityNodes(Repository.liveSession);

function migrateCalendarActivityNodes(s)
{
    let count = 0;
    let removeCount = 0;
    
    const xpath = "//element(*, ametys:activity)[@ametys:activityTypeId = 'workpace.calendar.event.updated']";
    
    Repository.query(xpath, true, s).forEach(function(activity) {
        
        let eventId = activity.getValue("eventId");
        
	    try
        {
            let calendarEvent = Repository.resolver.resolveById(eventId);
            activity.setValue("eventStartDate", calendarEvent.getStartDate());
            activity.setValue("eventEndDate", calendarEvent.getEndDate());
            activity.setValue("eventFullDay", calendarEvent.getFullDay());
            activity.setValue("eventRecurrence", calendarEvent.getRecurrenceType().name().toUpperCase());
            if (!calendarEvent.getRecurrenceType().equals(EventRecurrenceTypeEnum.NEVER) && calendarEvent.getRepeatUntil() != null)
            {
                activity.setValue("eventRepeatUntil", DateUtils.zonedDateTimeToString(calendarEvent.getRepeatUntil()));
            }
            
            count++;
        }
        catch (e)
        {
            removeCount++;
            activity.remove();
        }
	});

    s.save();
    logger.info(`${count} calendar activities have been migrated in workspace ${s.getWorkspace().getName}`);
    logger.info(`${removeCount} calendar activities have been removed in workspace ${s.getWorkspace().getName}`);
    
}