/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

  transform(Repository.session);
  transform(Repository.liveSession);

  function transformWorkspaces(s)
  {
      let count = 0;
      const siteNodes = Repository.query("//element(*, ametys:site)[@ametys:type='workspaces.project']", false, s);
      while (siteNodes.hasNext())
      {
          let node = siteNodes.next();
          if (node.hasProperty("ametys:overrideExcludedPopulation"))
          {
              let externalPopulationsString = node.getProperty("ametys:workspacesExcludedPopulationProject").getString();
              node.setProperty("ametys:workspacesExternalPopulationProject", externalPopulationsString);
              node.setProperty("ametys:externalPopulationPolicy", "EXTERNAL_POPULATION_BY_PROJECT");
              node.getSession().save();
              count++;
          }
      }
      logger.info(`${count} workspaces site have been migrated (JCR nodes) in ${s.getWorkspace().getName()} workspace`);
  }

  function transformCatalog(s)
  {
      let count = 0;
      const siteNodes = Repository.query("//element(*, ametys:site)[@ametys:type='workspaces.catalog']", false, s);
      while (siteNodes.hasNext())
      {
          let node = siteNodes.next();
          if (node.hasProperty("ametys:workspacesExcludedPopulation"))
          {
              let externalPopulationsString = node.getProperty("ametys:workspacesExcludedPopulation").getString();
              node.setProperty("ametys:workspacesExternalPopulation", externalPopulationsString);
              node.getSession().save();
              count++;
          }
      }
      logger.info(`${count} workspaces site have been migrated (JCR nodes) in ${s.getWorkspace().getName()} workspace`);
  }
  

  function transform(s)
  {
      transformWorkspaces(s);
      transformCatalog(s);
  }