/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
    
let projectManager = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.ProjectManager.ROLE);
let workspaceModuleExtensionPoint = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint.ROLE);

checkPageVisibility(Repository.session);
checkPageVisibility(Repository.liveSession);

function checkPageVisibility(session)
{
    let count = 0;
    let projects = Repository.query("//element(*, ametys:project)", true, session);
    for (let project of projects)
    {
        let modules = workspaceModuleExtensionPoint.getModules().iterator();
        while (modules.hasNext())
        {
            let module = modules.next();
            let isActivated = projectManager.isModuleActivated(project, module.getId())
            let pages = projectManager.getModulePages(project, module);
            for (let page of pages)
            {
                let isVisible = page.isVisible()
                if (isVisible != isActivated)
                {
                    if (isActivated)
                    {
                        module.activateModule(project);
                    }
                    else
                    {
                        module.deactivateModule(project);
                    }
                    count++;
                }
            }
        }
    }
    logger.info(`${count} page visibility have been changed to match module's activation state in ${session.getWorkspace().getName()} workspace`);
}

