    /*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
checkWorkspaceModuleLink(Repository.session);
checkWorkspaceModuleLink(Repository.liveSession);

function checkWorkspaceModuleLink(session)
{
    let count = 0;
    let pages = Repository.query("//element(documents, ametys:defaultPage)[@ametys:workspaces-modules]", false, session);
    for (let page of pages)
    {
        let moduleLinks = page.getProperty("ametys:workspaces-modules").getValues();
        let valueChanged = false;

        var newModuleLinks = [];
        for (var i = 0; i < moduleLinks.length; i++)
        {
            let moduleLink = moduleLinks[i].getString()

            if (moduleLink.startsWith("resources-collection://"))
            {
                moduleLink = moduleLink.replace("resources-collection://", "folder://");
                valueChanged = true;
            }
            newModuleLinks.push(moduleLink)
        }
        
        if (valueChanged)
        {
            Repository.helper.setProperty(page, "ametys:workspaces-modules", newModuleLinks);
            page.save();
            count++;
        }
    }
    logger.info(`${count} page workspaces modules link have been corrected in ${session.getWorkspace().getName()} workspace`);

}
