<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
                xmlns:math="java.lang.Math"
                extension-element-prefixes="ametys escape math">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="plugin:core-impl://stylesheets/vuejs/helper.xsl" /> 
    <xsl:import href="../../common.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="common-service-name">module-document</xsl:variable>
    
    <xsl:template name="common-service-head-title"/>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="common-workspaces-js"/>
        
        <script type="text/javascript" src="{ametys:pluginResourceURL('mediaelement', 'js/mediaelement-and-player.min.js')}"></script>
        
        <!-- JS for OnlyOffice -->
        <xsl:call-template name="onlyoffice-js"/>
        
        <xsl:call-template name="vuejs-head">          
            <xsl:with-param name="component">file-manager</xsl:with-param>          
            <xsl:with-param name="location" select="ametys:pluginResourceURL('workspaces', 'vuejs/file-manager')"/>  
        </xsl:call-template>   
    </xsl:template>
    
    <xsl:template name="onlyoffice-js">
        <script type="text/javascript">
            DocsAPI = {}; // DO NOT REMOVE !! Mandatory if OO is not enabled !!
        </script>
        <xsl:variable name="onlyOfficeEnabled" select="ametys:config('workspaces.onlyoffice.enabled')"/>
        <xsl:if test="$onlyOfficeEnabled = 'true'">
            <script type="text/javascript" src="{ametys:config('workspaces.onlyoffice.server.url')}/web-apps/apps/api/documents/api.js"/>   
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
        <xsl:call-template name="common-workspaces-css"/>
        
        <xsl:variable name="url"><xsl:value-of select="ametys:absoluteUriPrefix()" />/plugins/workspaces/<xsl:value-of select="ametys:site()" />/project-tags.min.css</xsl:variable>
        <link rel="stylesheet" href="{$url}" />
        
    </xsl:template>
        
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="vuejs">          
            <xsl:with-param name="component">file-manager</xsl:with-param>          
            <xsl:with-param name="uniqueId">file-manager</xsl:with-param>
            <xsl:with-param name="config">{
                "onlyOfficeEnabled": "<xsl:value-of select="ametys:config('workspaces.onlyoffice.enabled')"/>" == 'true', 
                "onlyOfficeEditionEnabled": "<xsl:value-of select="ametys:config('workspaces.onlyoffice.edition.enabled')"/>" == 'true', 
                "msOfficeEnabled": "<xsl:value-of select="ametys:config('workspaces.msoffice.enabled')"/>" == 'true'
            }</xsl:with-param>
        </xsl:call-template> 
    </xsl:template>
    
</xsl:stylesheet>
