<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                xmlns:ametysProject="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                extension-element-prefixes="ametys math">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="plugin:core-impl://stylesheets/vuejs/helper.xsl" /> 
    <xsl:import href="../../common.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="common-service-name">module-tasks</xsl:variable>
    
    <xsl:template name="common-service-head-title"/>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="common-workspaces-js"/>

        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', 'js/fixed-scrollbar.js')}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', 'js/sticky-header.js')}"></script>
        
        <xsl:call-template name="vuejs-head">          
            <xsl:with-param name="component">tasks</xsl:with-param>          
            <xsl:with-param name="location" select="ametys:pluginResourceURL('workspaces', 'vuejs/tasks')"/>  
        </xsl:call-template>   
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
        <xsl:call-template name="common-workspaces-css"/>
        
        <xsl:variable name="url"><xsl:value-of select="ametys:absoluteUriPrefix()" />/plugins/workspaces/<xsl:value-of select="ametys:site()" />/project-tags.min.css</xsl:variable>
        <link rel="stylesheet" href="{$url}" />
        
    </xsl:template>
        
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        
        <div id="tasks-module"></div>
        
        <xsl:call-template name="vuejs">
            <xsl:with-param name="component">tasks</xsl:with-param>
            <xsl:with-param name="uniqueId">tasks-module</xsl:with-param>
            <xsl:with-param name="config">{
                "exportLinks": function() { return <xsl:apply-templates select="/tasks/exportLinks"/> }
            }</xsl:with-param>
        </xsl:call-template> 
    </xsl:template>

    <xsl:template match="exportLinks">
        <xsl:text>[</xsl:text>
        <xsl:for-each select="link">
            <xsl:if test="position()!=1"><xsl:text>,</xsl:text></xsl:if>
            <xsl:text>{</xsl:text>
            <xsl:text>"listLabel": "</xsl:text><xsl:copy-of select="listLabel/node()"/><xsl:text>",</xsl:text>
            <xsl:text>"title": "</xsl:text><xsl:copy-of select="titleLabel/node()"/><xsl:text>",</xsl:text>
            <xsl:text>"description": "</xsl:text><xsl:copy-of select="descritptionLabel/node()"/><xsl:text>",</xsl:text>
            <xsl:text>"icon": "</xsl:text><xsl:value-of select="icon"/><xsl:text>",</xsl:text>
            <xsl:text>"url": "</xsl:text><xsl:value-of select="url"/><xsl:text>",</xsl:text>
            <xsl:text>"openingMode": "</xsl:text><xsl:value-of select="openingMode"/><xsl:text>"</xsl:text>
            <xsl:text>}</xsl:text>
        </xsl:for-each>
        <xsl:text>]</xsl:text>
    </xsl:template>

    
</xsl:stylesheet>
