<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
                xmlns:math="java.lang.Math"
                extension-element-prefixes="ametys escape math project">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="plugin:core-impl://stylesheets/vuejs/helper.xsl" /> 
    <xsl:import href="../common.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="common-service-name">service-projects-catalogue</xsl:variable>
    
    <xsl:template name="common-service-head-title"/>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="common-workspaces-js"/>
        
        <xsl:call-template name="vuejs-head">          
            <xsl:with-param name="component">catalog</xsl:with-param>          
            <xsl:with-param name="location" select="ametys:pluginResourceURL('workspaces', 'vuejs/catalog')"/>  
        </xsl:call-template>   
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
        <xsl:call-template name="common-workspaces-css"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="vuejs">          
            <xsl:with-param name="component">catalog</xsl:with-param>          
            <xsl:with-param name="uniqueId">catalog</xsl:with-param>
            <xsl:with-param name="config">{
                "cmsUrl": "<xsl:value-of select="ametys:config('cms.url')"/>", 
                "languagesList": [<xsl:for-each select="ametys:service-parameter('availableLanguages')/value"><xsl:if test="position() != 1">, </xsl:if>{ value: "<xsl:value-of select='.'/>", label: "<xsl:value-of select='project:getLanguageLabel(., ametys:lang())'/>" }</xsl:for-each>],
                "defaultLanguage": "<xsl:value-of select='project:computeDefaultLanguage(ametys:lang())'/>",
                "sitename": "<xsl:value-of select="ametys:site()"/>",
                "zoneitemId": "<xsl:value-of select="ametys:zoneItemId()"/>",
                "profiles": [<xsl:for-each select="/catalog/profiles/profile"><xsl:if test="position() != 1">, </xsl:if>{ id: "<xsl:value-of select='@id'/>", label: "<xsl:value-of select='label'/>"}</xsl:for-each>],
                "categories": function() { return [<xsl:apply-templates select="/catalog/categories/category"/>] },
                "modules": function() { return [<xsl:apply-templates select="/catalog/modules/module"/>] }
            }</xsl:with-param>
        </xsl:call-template> 

    </xsl:template>
    
    <xsl:template match="module"><xsl:if test="position() != 1">, </xsl:if>{ id: "<xsl:value-of select="@id"/>", title: "<xsl:copy-of select="title/*"/>", description: "<xsl:copy-of select="description/*"/>", unselected: "<xsl:value-of select="@unselected"/>" == "true" }</xsl:template> 
    <xsl:template match="category"><xsl:if test="position() != 1">, </xsl:if>{ name: "<xsl:value-of select='name'/>", title: "<xsl:value-of select='title'/>", color: "<xsl:value-of select='color'/>"<xsl:if test="children">, "children": [ <xsl:apply-templates select="children/category"/> ]</xsl:if> }</xsl:template>
    
</xsl:stylesheet>
