<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="java.lang.Math"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                extension-element-prefixes="ametys resolver math">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="link" select="ametys:serviceParameter('link')/text()"/>
    <xsl:variable name="link-text" select="ametys:serviceParameter('link-text')/text()"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">document-stream</xsl:variable>
    <xsl:variable name="common-service-name">service-document-stream</xsl:variable>
    
    <xsl:variable name="date-format" select="ametys:translate('plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_SIMPLE_DOCUMENT_DATE_FORMAT')"></xsl:variable>
    <xsl:variable name="time-format" select="ametys:translate('plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_SIMPLE_DOCUMENT_TIME_FORMAT')"></xsl:variable>
    
    <!-- +
         | HEAD
         + -->   
    <!-- Used by common -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
    	<xsl:choose>
    		<xsl:when test="document">
    			<xsl:call-template name="documents"/>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:call-template name="documents-empty"/>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template name="documents">
    	<ul class="documents">
	        <xsl:apply-templates select="document">
	            <xsl:sort select="last-modified" order="descending" />
	        </xsl:apply-templates>
	    </ul>
    </xsl:template>
    
    <xsl:template name="documents-empty">
    	<p><i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_SIMPLE_DOCUMENT_NO_RESULTS" /></p>
        <xsl:call-template name="link" />
    </xsl:template>
    
    <xsl:template match="document">
        <li>
        	<xsl:attribute name="class"><xsl:call-template name="common-utils-class"/> document-entry</xsl:attribute>
        	<xsl:call-template name="document-date"/>
        	<xsl:call-template name="document-msg"/>
        </li>
    </xsl:template>
    
    <xsl:template name="document-date">
    	 <div class="document-entry-date">
    		<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-format}" value="{lastModified}"/>
    		<xsl:text> </xsl:text>
    		<i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$time-format}" value="{lastModified}"/>
         </div>
    </xsl:template>
    
    <xsl:template name="document-msg">
    	 <div class="document-entry-msg">
            <i18n:translate>
                <i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_SIMPLE_DOCUMENT_ENTRY_MESSAGE" />
                <i18n:param name="user"><xsl:call-template name="document-entry-author"/></i18n:param>
                <i18n:param name="file"><xsl:call-template name="document-entry-filename"/></i18n:param>
                <i18n:param name="folder"><xsl:call-template name="document-entry-folder"/></i18n:param>
                <i18n:param name="project"><xsl:call-template name="document-entry-project"/></i18n:param>
            </i18n:translate>
          </div>
    </xsl:template>
    
    <xsl:template name="document-entry-author">
    	<span class="document-author">
        	<img src="{$site-uri-prefix}/_plugins/core-ui/user/{user/@population}/{uriutils:encodePath(user/@login)}/image_26" alt="" title="{user/fullname}"/>
        	<xsl:value-of select="user/fullname" />
        </span>
    </xsl:template>
    
    <xsl:template name="document-entry-filename">
    	<a href="{resolver:resolve('project-resource', @id, true(), true())}" class="document-filename"><xsl:value-of select="name" /></a>
    </xsl:template>
    
    <xsl:template name="document-entry-folder">
    	<a target="_blank" href="{folder/@url}" class="document-folder"><xsl:value-of select="folder" /></a>
    </xsl:template>
    
    <xsl:template name="document-entry-project">
        <xsl:choose>
            <xsl:when test="project/@hasAccess = 'true'">
                <a href="{project/@url}" target="_blank" class="document-project" title="plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_SIMPLE_PROJECTS_CATALOGUE_ACCESS" i18n:attr="title"><xsl:value-of select="project" /></a>
            </xsl:when>
            <xsl:otherwise>
		    	<span class="document-project"><xsl:value-of select="project" /></span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Template to use the link -->
    <xsl:template name="link">
        <xsl:if test="starts-with($link, 'page://')">
            <xsl:variable name="url" select="resolver:resolve('page', $link)"/>
            <xsl:if test="$url != ''">
                <div class="link document-stream-link">
                    <a href="{$url}">
                        <xsl:choose>
                            <xsl:when test="$link-text != ''">
                                <xsl:value-of select="$link-text"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="ametys:pageTitle($link)"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </a>
                </div>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
