<?xml version="1.0" encoding="UTF-8" ?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
                    
    <xsl:template match="colors">
        <text>
            <xsl:text>[</xsl:text>
            <xsl:for-each select="color">
                <xsl:if test="position()!=1"><xsl:text>,</xsl:text></xsl:if>
                <xsl:call-template name="color" />
            </xsl:for-each>
            <xsl:text>]</xsl:text>
        </text>
    </xsl:template>
    
    <xsl:template name="color">
        <xsl:text>{</xsl:text>
        <xsl:text>"id": "</xsl:text><xsl:value-of select="@id"/><xsl:text>",</xsl:text>
        <xsl:text>"label": "</xsl:text><xsl:value-of select="label"/><xsl:text>",</xsl:text>
        <xsl:text>"border": "</xsl:text><xsl:value-of select="border"/><xsl:text>",</xsl:text>
        <xsl:text>"bg": "</xsl:text><xsl:value-of select="bg"/><xsl:text>",</xsl:text>
        <xsl:text>"fg": "</xsl:text><xsl:value-of select="fg"/><xsl:text>",</xsl:text>
        <xsl:text>"fgnobackground": "</xsl:text><xsl:value-of select="fgnobackground"/><xsl:text>"</xsl:text>
        <xsl:text>}</xsl:text>
    </xsl:template>
</xsl:stylesheet>