<?xml version="1.0" encoding="UTF-8" ?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
					
	<xsl:template match="colors">
		<colors>
		  .ext-cal-hd-ad-inner {
		      height: 1000px !important;
		  }
          .ext-cal-evo {
              border: solid 1px transparent !important;
              padding: 1px 1px 1px 5px !important;
          }
          .ext-cal-evm {
              border-style: none !important;
          }
		  .ext-cal-evr {
              border: solid 1px transparent !important;
              padding: 1px 1px 1px 5px !important;
              background-color: #FFFFFF;
          }
          .ext-cal-dayview .ext-cal-evo,
          .ext-cal-dayview .ext-cal-evr {
              border: solid 1px #FFFFFF !important;
          }
          
		.x-boundlist.ametys-boundlist.calendar-color .x-boundlist-item
		{
		  line-height: 15px;
		}

		.calendar-color .x-form-text-wrap
		{
		    position: relative;
		}
		
		  .calendar-color input.x-form-field
		  {
		      padding-left: 23px !important;
		  }
		<xsl:for-each select="color">
			<xsl:call-template name="color" />
		</xsl:for-each>
		</colors>
	</xsl:template>
	
	<xsl:template name="color">
	    .calendar-color-<xsl:value-of select="@id"/>-combobox
	    {
	       padding: 1px;
	    }
	    
	    .ext-cal-picker-icon.calendar-color-<xsl:value-of select="@id"/>
		{
		      border: 1px solid <xsl:value-of select="border"/>;
		      color: <xsl:value-of select="fg"/>;
		      background-color: <xsl:value-of select="bg"/>;
              top: 3px;
              left: 3px;
              position: absolute;
              border-radius: 20px;
              height: 14px;
              width: 14px;
		}
		
        .calendar-color-<xsl:value-of select="@id"/> span.x-tree-node-text:after
        {
			content: ' ';
			border-radius: 8px;
			width: 8px;
			height: 8px;
			display: inline-block;
			background-color: <xsl:value-of select="bg"/>;
			color: <xsl:value-of select="fg"/>;
			border: 1px solid <xsl:value-of select="border"/>;
			position: relative;
			top: 1px;
			left: 4px;
        }
	    
		.calendar-color-<xsl:value-of select="@id"/>-combobox div 
        {
              border-radius: 5px;
              padding-left: 10px;
		      background-color: <xsl:value-of select="bg"/>;
		      color: <xsl:value-of select="fg"/>;
		      border: 1px solid <xsl:value-of select="border"/>;
		}
		
		.calendar-color-<xsl:value-of select="@id"/>-combobox.x-boundlist-selected
		{
		  background-color: #CFCFCF;
		}
		
        .ext-cal-dayview .ext-cal-select-<xsl:value-of select="@id"/>,
		.ext-cal-monthview .ext-cal-select-<xsl:value-of select="@id"/> {
		  border: solid 1px <xsl:value-of select="border"/> !important;
		}
		
		.ext-ie .ext-color-<xsl:value-of select="@id"/>-ad,
		.ext-opera .ext-color-<xsl:value-of select="@id"/>-ad {
		    color: <xsl:value-of select="fg"/> !important;
		}
		
		.ext-color-<xsl:value-of select="@id"/>{
		    color: <xsl:value-of select="fgnobackground"/> !important;
        }
		
		.ext-cal-day-col .ext-color-<xsl:value-of select="@id"/>,
		.ext-dd-drag-proxy .ext-color-<xsl:value-of select="@id"/>,
		.ext-color-<xsl:value-of select="@id"/>-ad,
		.ext-color-<xsl:value-of select="@id"/>-ad .ext-cal-evm,
        .ext-color-<xsl:value-of select="@id"/>-ad .ext-cal-evi,
		.ext-color-<xsl:value-of select="@id"/> .ext-cal-picker-icon,
		.ext-color-<xsl:value-of select="@id"/>-x dl,
		.ext-color-<xsl:value-of select="@id"/>-x .ext-cal-evb {
            color: <xsl:value-of select="fg"/> !important;
		    background: <xsl:value-of select="bg"/> !important;
		}
		.ext-color-<xsl:value-of select="@id"/>-x .ext-cal-evb,
		.ext-color-<xsl:value-of select="@id"/>-x dl {
		    border-color: <xsl:value-of select="border"/> !important;
		}
		
	</xsl:template>
	
</xsl:stylesheet>